/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class RestoreParametersBase
implements JsonSerializable<RestoreParametersBase> {
    private String restoreSource;
    private OffsetDateTime restoreTimestampInUtc;
    private Boolean restoreWithTtlDisabled;

    public String restoreSource() {
        return this.restoreSource;
    }

    public RestoreParametersBase withRestoreSource(String restoreSource) {
        this.restoreSource = restoreSource;
        return this;
    }

    public OffsetDateTime restoreTimestampInUtc() {
        return this.restoreTimestampInUtc;
    }

    public RestoreParametersBase withRestoreTimestampInUtc(OffsetDateTime restoreTimestampInUtc) {
        this.restoreTimestampInUtc = restoreTimestampInUtc;
        return this;
    }

    public Boolean restoreWithTtlDisabled() {
        return this.restoreWithTtlDisabled;
    }

    public RestoreParametersBase withRestoreWithTtlDisabled(Boolean restoreWithTtlDisabled) {
        this.restoreWithTtlDisabled = restoreWithTtlDisabled;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("restoreSource", this.restoreSource);
        jsonWriter.writeStringField("restoreTimestampInUtc", this.restoreTimestampInUtc == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.restoreTimestampInUtc));
        jsonWriter.writeBooleanField("restoreWithTtlDisabled", this.restoreWithTtlDisabled);
        return jsonWriter.writeEndObject();
    }

    public static RestoreParametersBase fromJson(JsonReader jsonReader) throws IOException {
        return (RestoreParametersBase)jsonReader.readObject(reader -> {
            RestoreParametersBase deserializedRestoreParametersBase = new RestoreParametersBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("restoreSource".equals(fieldName)) {
                    deserializedRestoreParametersBase.restoreSource = reader.getString();
                    continue;
                }
                if ("restoreTimestampInUtc".equals(fieldName)) {
                    deserializedRestoreParametersBase.restoreTimestampInUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("restoreWithTtlDisabled".equals(fieldName)) {
                    deserializedRestoreParametersBase.restoreWithTtlDisabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestoreParametersBase;
        });
    }
}

