/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.BackupPolicyMigrationStatus;
import com.azure.resourcemanager.cosmos.models.BackupPolicyType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class BackupPolicyMigrationState
implements JsonSerializable<BackupPolicyMigrationState> {
    private BackupPolicyMigrationStatus status;
    private BackupPolicyType targetType;
    private OffsetDateTime startTime;

    public BackupPolicyMigrationStatus status() {
        return this.status;
    }

    public BackupPolicyMigrationState withStatus(BackupPolicyMigrationStatus status) {
        this.status = status;
        return this;
    }

    public BackupPolicyType targetType() {
        return this.targetType;
    }

    public BackupPolicyMigrationState withTargetType(BackupPolicyType targetType) {
        this.targetType = targetType;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public BackupPolicyMigrationState withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("targetType", this.targetType == null ? null : this.targetType.toString());
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        return jsonWriter.writeEndObject();
    }

    public static BackupPolicyMigrationState fromJson(JsonReader jsonReader) throws IOException {
        return (BackupPolicyMigrationState)jsonReader.readObject(reader -> {
            BackupPolicyMigrationState deserializedBackupPolicyMigrationState = new BackupPolicyMigrationState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedBackupPolicyMigrationState.status = BackupPolicyMigrationStatus.fromString(reader.getString());
                    continue;
                }
                if ("targetType".equals(fieldName)) {
                    deserializedBackupPolicyMigrationState.targetType = BackupPolicyType.fromString(reader.getString());
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedBackupPolicyMigrationState.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupPolicyMigrationState;
        });
    }
}

