/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cosmos.fluent.RestorableGremlinGraphsClient;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableGremlinGraphGetResultInner;
import com.azure.resourcemanager.cosmos.implementation.CosmosDBManagementClientImpl;
import com.azure.resourcemanager.cosmos.models.RestorableGremlinGraphsListResult;
import reactor.core.publisher.Mono;

public final class RestorableGremlinGraphsClientImpl
implements RestorableGremlinGraphsClient {
    private final RestorableGremlinGraphsService service;
    private final CosmosDBManagementClientImpl client;

    RestorableGremlinGraphsClientImpl(CosmosDBManagementClientImpl client) {
        this.service = (RestorableGremlinGraphsService)RestProxy.create(RestorableGremlinGraphsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableGremlinGraphGetResultInner>> listSinglePageAsync(String location, String instanceId, String restorableGremlinDatabaseRid, String startTime, String endTime) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, restorableGremlinDatabaseRid, startTime, endTime, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableGremlinGraphsListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RestorableGremlinGraphGetResultInner>> listSinglePageAsync(String location, String instanceId, String restorableGremlinDatabaseRid, String startTime, String endTime, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), location, instanceId, restorableGremlinDatabaseRid, startTime, endTime, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RestorableGremlinGraphsListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableGremlinGraphGetResultInner> listAsync(String location, String instanceId, String restorableGremlinDatabaseRid, String startTime, String endTime) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId, restorableGremlinDatabaseRid, startTime, endTime));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RestorableGremlinGraphGetResultInner> listAsync(String location, String instanceId) {
        String restorableGremlinDatabaseRid = null;
        String startTime = null;
        String endTime = null;
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId, restorableGremlinDatabaseRid, startTime, endTime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RestorableGremlinGraphGetResultInner> listAsync(String location, String instanceId, String restorableGremlinDatabaseRid, String startTime, String endTime, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, instanceId, restorableGremlinDatabaseRid, startTime, endTime, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableGremlinGraphGetResultInner> list(String location, String instanceId) {
        String restorableGremlinDatabaseRid = null;
        String startTime = null;
        String endTime = null;
        return new PagedIterable(this.listAsync(location, instanceId, restorableGremlinDatabaseRid, startTime, endTime));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RestorableGremlinGraphGetResultInner> list(String location, String instanceId, String restorableGremlinDatabaseRid, String startTime, String endTime, Context context) {
        return new PagedIterable(this.listAsync(location, instanceId, restorableGremlinDatabaseRid, startTime, endTime, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CosmosDBManagementCl")
    public static interface RestorableGremlinGraphsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{instanceId}/restorableGraphs")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RestorableGremlinGraphsListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="location") String var4, @PathParam(value="instanceId") String var5, @QueryParam(value="restorableGremlinDatabaseRid") String var6, @QueryParam(value="startTime") String var7, @QueryParam(value="endTime") String var8, @HeaderParam(value="Accept") String var9, Context var10);
    }
}

