/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.LicenseType;
import com.azure.resourcemanager.containerservice.models.WindowsGmsaProfile;
import java.io.IOException;

public final class ManagedClusterWindowsProfile
implements JsonSerializable<ManagedClusterWindowsProfile> {
    private String adminUsername;
    private String adminPassword;
    private LicenseType licenseType;
    private Boolean enableCsiProxy;
    private WindowsGmsaProfile gmsaProfile;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedClusterWindowsProfile.class);

    public String adminUsername() {
        return this.adminUsername;
    }

    public ManagedClusterWindowsProfile withAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
        return this;
    }

    public String adminPassword() {
        return this.adminPassword;
    }

    public ManagedClusterWindowsProfile withAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
        return this;
    }

    public LicenseType licenseType() {
        return this.licenseType;
    }

    public ManagedClusterWindowsProfile withLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public Boolean enableCsiProxy() {
        return this.enableCsiProxy;
    }

    public ManagedClusterWindowsProfile withEnableCsiProxy(Boolean enableCsiProxy) {
        this.enableCsiProxy = enableCsiProxy;
        return this;
    }

    public WindowsGmsaProfile gmsaProfile() {
        return this.gmsaProfile;
    }

    public ManagedClusterWindowsProfile withGmsaProfile(WindowsGmsaProfile gmsaProfile) {
        this.gmsaProfile = gmsaProfile;
        return this;
    }

    public void validate() {
        if (this.adminUsername() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property adminUsername in model ManagedClusterWindowsProfile"));
        }
        if (this.gmsaProfile() != null) {
            this.gmsaProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("adminUsername", this.adminUsername);
        jsonWriter.writeStringField("adminPassword", this.adminPassword);
        jsonWriter.writeStringField("licenseType", this.licenseType == null ? null : this.licenseType.toString());
        jsonWriter.writeBooleanField("enableCSIProxy", this.enableCsiProxy);
        jsonWriter.writeJsonField("gmsaProfile", (JsonSerializable)this.gmsaProfile);
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterWindowsProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterWindowsProfile)jsonReader.readObject(reader -> {
            ManagedClusterWindowsProfile deserializedManagedClusterWindowsProfile = new ManagedClusterWindowsProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("adminUsername".equals(fieldName)) {
                    deserializedManagedClusterWindowsProfile.adminUsername = reader.getString();
                    continue;
                }
                if ("adminPassword".equals(fieldName)) {
                    deserializedManagedClusterWindowsProfile.adminPassword = reader.getString();
                    continue;
                }
                if ("licenseType".equals(fieldName)) {
                    deserializedManagedClusterWindowsProfile.licenseType = LicenseType.fromString(reader.getString());
                    continue;
                }
                if ("enableCSIProxy".equals(fieldName)) {
                    deserializedManagedClusterWindowsProfile.enableCsiProxy = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("gmsaProfile".equals(fieldName)) {
                    deserializedManagedClusterWindowsProfile.gmsaProfile = WindowsGmsaProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterWindowsProfile;
        });
    }
}

