/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.BackendPoolType;
import com.azure.resourcemanager.containerservice.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs;
import com.azure.resourcemanager.containerservice.models.ManagedClusterLoadBalancerProfileOutboundIPs;
import com.azure.resourcemanager.containerservice.models.ManagedClusterLoadBalancerProfileOutboundIpPrefixes;
import com.azure.resourcemanager.containerservice.models.ResourceReference;
import java.io.IOException;
import java.util.List;

public final class ManagedClusterLoadBalancerProfile
implements JsonSerializable<ManagedClusterLoadBalancerProfile> {
    private ManagedClusterLoadBalancerProfileManagedOutboundIPs managedOutboundIPs;
    private ManagedClusterLoadBalancerProfileOutboundIpPrefixes outboundIpPrefixes;
    private ManagedClusterLoadBalancerProfileOutboundIPs outboundIPs;
    private List<ResourceReference> effectiveOutboundIPs;
    private Integer allocatedOutboundPorts;
    private Integer idleTimeoutInMinutes;
    private Boolean enableMultipleStandardLoadBalancers;
    private BackendPoolType backendPoolType;

    public ManagedClusterLoadBalancerProfileManagedOutboundIPs managedOutboundIPs() {
        return this.managedOutboundIPs;
    }

    public ManagedClusterLoadBalancerProfile withManagedOutboundIPs(ManagedClusterLoadBalancerProfileManagedOutboundIPs managedOutboundIPs) {
        this.managedOutboundIPs = managedOutboundIPs;
        return this;
    }

    public ManagedClusterLoadBalancerProfileOutboundIpPrefixes outboundIpPrefixes() {
        return this.outboundIpPrefixes;
    }

    public ManagedClusterLoadBalancerProfile withOutboundIpPrefixes(ManagedClusterLoadBalancerProfileOutboundIpPrefixes outboundIpPrefixes) {
        this.outboundIpPrefixes = outboundIpPrefixes;
        return this;
    }

    public ManagedClusterLoadBalancerProfileOutboundIPs outboundIPs() {
        return this.outboundIPs;
    }

    public ManagedClusterLoadBalancerProfile withOutboundIPs(ManagedClusterLoadBalancerProfileOutboundIPs outboundIPs) {
        this.outboundIPs = outboundIPs;
        return this;
    }

    public List<ResourceReference> effectiveOutboundIPs() {
        return this.effectiveOutboundIPs;
    }

    public Integer allocatedOutboundPorts() {
        return this.allocatedOutboundPorts;
    }

    public ManagedClusterLoadBalancerProfile withAllocatedOutboundPorts(Integer allocatedOutboundPorts) {
        this.allocatedOutboundPorts = allocatedOutboundPorts;
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public ManagedClusterLoadBalancerProfile withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public Boolean enableMultipleStandardLoadBalancers() {
        return this.enableMultipleStandardLoadBalancers;
    }

    public ManagedClusterLoadBalancerProfile withEnableMultipleStandardLoadBalancers(Boolean enableMultipleStandardLoadBalancers) {
        this.enableMultipleStandardLoadBalancers = enableMultipleStandardLoadBalancers;
        return this;
    }

    public BackendPoolType backendPoolType() {
        return this.backendPoolType;
    }

    public ManagedClusterLoadBalancerProfile withBackendPoolType(BackendPoolType backendPoolType) {
        this.backendPoolType = backendPoolType;
        return this;
    }

    public void validate() {
        if (this.managedOutboundIPs() != null) {
            this.managedOutboundIPs().validate();
        }
        if (this.outboundIpPrefixes() != null) {
            this.outboundIpPrefixes().validate();
        }
        if (this.outboundIPs() != null) {
            this.outboundIPs().validate();
        }
        if (this.effectiveOutboundIPs() != null) {
            this.effectiveOutboundIPs().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("managedOutboundIPs", (JsonSerializable)this.managedOutboundIPs);
        jsonWriter.writeJsonField("outboundIPPrefixes", (JsonSerializable)this.outboundIpPrefixes);
        jsonWriter.writeJsonField("outboundIPs", (JsonSerializable)this.outboundIPs);
        jsonWriter.writeNumberField("allocatedOutboundPorts", (Number)this.allocatedOutboundPorts);
        jsonWriter.writeNumberField("idleTimeoutInMinutes", (Number)this.idleTimeoutInMinutes);
        jsonWriter.writeBooleanField("enableMultipleStandardLoadBalancers", this.enableMultipleStandardLoadBalancers);
        jsonWriter.writeStringField("backendPoolType", this.backendPoolType == null ? null : this.backendPoolType.toString());
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterLoadBalancerProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterLoadBalancerProfile)jsonReader.readObject(reader -> {
            ManagedClusterLoadBalancerProfile deserializedManagedClusterLoadBalancerProfile = new ManagedClusterLoadBalancerProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managedOutboundIPs".equals(fieldName)) {
                    deserializedManagedClusterLoadBalancerProfile.managedOutboundIPs = ManagedClusterLoadBalancerProfileManagedOutboundIPs.fromJson(reader);
                    continue;
                }
                if ("outboundIPPrefixes".equals(fieldName)) {
                    deserializedManagedClusterLoadBalancerProfile.outboundIpPrefixes = ManagedClusterLoadBalancerProfileOutboundIpPrefixes.fromJson(reader);
                    continue;
                }
                if ("outboundIPs".equals(fieldName)) {
                    deserializedManagedClusterLoadBalancerProfile.outboundIPs = ManagedClusterLoadBalancerProfileOutboundIPs.fromJson(reader);
                    continue;
                }
                if ("effectiveOutboundIPs".equals(fieldName)) {
                    List effectiveOutboundIPs;
                    deserializedManagedClusterLoadBalancerProfile.effectiveOutboundIPs = effectiveOutboundIPs = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    continue;
                }
                if ("allocatedOutboundPorts".equals(fieldName)) {
                    deserializedManagedClusterLoadBalancerProfile.allocatedOutboundPorts = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedManagedClusterLoadBalancerProfile.idleTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enableMultipleStandardLoadBalancers".equals(fieldName)) {
                    deserializedManagedClusterLoadBalancerProfile.enableMultipleStandardLoadBalancers = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("backendPoolType".equals(fieldName)) {
                    deserializedManagedClusterLoadBalancerProfile.backendPoolType = BackendPoolType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterLoadBalancerProfile;
        });
    }
}

