/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.OpenShiftManagedClusterBaseIdentityProvider;
import java.io.IOException;

public final class OpenShiftManagedClusterIdentityProvider
implements JsonSerializable<OpenShiftManagedClusterIdentityProvider> {
    private String name;
    private OpenShiftManagedClusterBaseIdentityProvider provider;

    public String name() {
        return this.name;
    }

    public OpenShiftManagedClusterIdentityProvider withName(String name) {
        this.name = name;
        return this;
    }

    public OpenShiftManagedClusterBaseIdentityProvider provider() {
        return this.provider;
    }

    public OpenShiftManagedClusterIdentityProvider withProvider(OpenShiftManagedClusterBaseIdentityProvider provider) {
        this.provider = provider;
        return this;
    }

    public void validate() {
        if (this.provider() != null) {
            this.provider().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("provider", (JsonSerializable)this.provider);
        return jsonWriter.writeEndObject();
    }

    public static OpenShiftManagedClusterIdentityProvider fromJson(JsonReader jsonReader) throws IOException {
        return (OpenShiftManagedClusterIdentityProvider)jsonReader.readObject(reader -> {
            OpenShiftManagedClusterIdentityProvider deserializedOpenShiftManagedClusterIdentityProvider = new OpenShiftManagedClusterIdentityProvider();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterIdentityProvider.name = reader.getString();
                    continue;
                }
                if ("provider".equals(fieldName)) {
                    deserializedOpenShiftManagedClusterIdentityProvider.provider = OpenShiftManagedClusterBaseIdentityProvider.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOpenShiftManagedClusterIdentityProvider;
        });
    }
}

