/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.ContainerInstanceOperationsOrigin;
import com.azure.resourcemanager.containerinstance.models.OperationDisplay;
import java.io.IOException;

public final class Operation
implements JsonSerializable<Operation> {
    private String name;
    private OperationDisplay display;
    private Object properties;
    private ContainerInstanceOperationsOrigin origin;
    private static final ClientLogger LOGGER = new ClientLogger(Operation.class);

    public String name() {
        return this.name;
    }

    public Operation withName(String name) {
        this.name = name;
        return this;
    }

    public OperationDisplay display() {
        return this.display;
    }

    public Operation withDisplay(OperationDisplay display) {
        this.display = display;
        return this;
    }

    public Object properties() {
        return this.properties;
    }

    public Operation withProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    public ContainerInstanceOperationsOrigin origin() {
        return this.origin;
    }

    public Operation withOrigin(ContainerInstanceOperationsOrigin origin) {
        this.origin = origin;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Operation"));
        }
        if (this.display() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property display in model Operation"));
        }
        this.display().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeUntypedField("properties", this.properties);
        jsonWriter.writeStringField("origin", this.origin == null ? null : this.origin.toString());
        return jsonWriter.writeEndObject();
    }

    public static Operation fromJson(JsonReader jsonReader) throws IOException {
        return (Operation)jsonReader.readObject(reader -> {
            Operation deserializedOperation = new Operation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperation.name = reader.getString();
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperation.display = OperationDisplay.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperation.properties = reader.readUntyped();
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperation.origin = ContainerInstanceOperationsOrigin.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperation;
        });
    }
}

