/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class Event
implements JsonSerializable<Event> {
    private Integer count;
    private OffsetDateTime firstTimestamp;
    private OffsetDateTime lastTimestamp;
    private String name;
    private String message;
    private String type;

    public Integer count() {
        return this.count;
    }

    public OffsetDateTime firstTimestamp() {
        return this.firstTimestamp;
    }

    public OffsetDateTime lastTimestamp() {
        return this.lastTimestamp;
    }

    public String name() {
        return this.name;
    }

    public String message() {
        return this.message;
    }

    public String type() {
        return this.type;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static Event fromJson(JsonReader jsonReader) throws IOException {
        return (Event)jsonReader.readObject(reader -> {
            Event deserializedEvent = new Event();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedEvent.count = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("firstTimestamp".equals(fieldName)) {
                    deserializedEvent.firstTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastTimestamp".equals(fieldName)) {
                    deserializedEvent.lastTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedEvent.name = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedEvent.message = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEvent.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEvent;
        });
    }
}

