/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.Architecture;
import com.azure.resourcemanager.compute.models.SupportedSecurityOption;
import java.io.IOException;

public final class SupportedCapabilities
implements JsonSerializable<SupportedCapabilities> {
    private String diskControllerTypes;
    private Boolean acceleratedNetwork;
    private Architecture architecture;
    private SupportedSecurityOption supportedSecurityOption;

    public String diskControllerTypes() {
        return this.diskControllerTypes;
    }

    public SupportedCapabilities withDiskControllerTypes(String diskControllerTypes) {
        this.diskControllerTypes = diskControllerTypes;
        return this;
    }

    public Boolean acceleratedNetwork() {
        return this.acceleratedNetwork;
    }

    public SupportedCapabilities withAcceleratedNetwork(Boolean acceleratedNetwork) {
        this.acceleratedNetwork = acceleratedNetwork;
        return this;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public SupportedCapabilities withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    public SupportedSecurityOption supportedSecurityOption() {
        return this.supportedSecurityOption;
    }

    public SupportedCapabilities withSupportedSecurityOption(SupportedSecurityOption supportedSecurityOption) {
        this.supportedSecurityOption = supportedSecurityOption;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diskControllerTypes", this.diskControllerTypes);
        jsonWriter.writeBooleanField("acceleratedNetwork", this.acceleratedNetwork);
        jsonWriter.writeStringField("architecture", this.architecture == null ? null : this.architecture.toString());
        jsonWriter.writeStringField("supportedSecurityOption", this.supportedSecurityOption == null ? null : this.supportedSecurityOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static SupportedCapabilities fromJson(JsonReader jsonReader) throws IOException {
        return (SupportedCapabilities)jsonReader.readObject(reader -> {
            SupportedCapabilities deserializedSupportedCapabilities = new SupportedCapabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("diskControllerTypes".equals(fieldName)) {
                    deserializedSupportedCapabilities.diskControllerTypes = reader.getString();
                    continue;
                }
                if ("acceleratedNetwork".equals(fieldName)) {
                    deserializedSupportedCapabilities.acceleratedNetwork = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("architecture".equals(fieldName)) {
                    deserializedSupportedCapabilities.architecture = Architecture.fromString(reader.getString());
                    continue;
                }
                if ("supportedSecurityOption".equals(fieldName)) {
                    deserializedSupportedCapabilities.supportedSecurityOption = SupportedSecurityOption.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSupportedCapabilities;
        });
    }
}

