/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ResourceRange;
import java.io.IOException;

public final class RecommendedMachineConfiguration
implements JsonSerializable<RecommendedMachineConfiguration> {
    private ResourceRange vCPUs;
    private ResourceRange memory;

    public ResourceRange vCPUs() {
        return this.vCPUs;
    }

    public RecommendedMachineConfiguration withVCPUs(ResourceRange vCPUs) {
        this.vCPUs = vCPUs;
        return this;
    }

    public ResourceRange memory() {
        return this.memory;
    }

    public RecommendedMachineConfiguration withMemory(ResourceRange memory) {
        this.memory = memory;
        return this;
    }

    public void validate() {
        if (this.vCPUs() != null) {
            this.vCPUs().validate();
        }
        if (this.memory() != null) {
            this.memory().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("vCPUs", (JsonSerializable)this.vCPUs);
        jsonWriter.writeJsonField("memory", (JsonSerializable)this.memory);
        return jsonWriter.writeEndObject();
    }

    public static RecommendedMachineConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (RecommendedMachineConfiguration)jsonReader.readObject(reader -> {
            RecommendedMachineConfiguration deserializedRecommendedMachineConfiguration = new RecommendedMachineConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vCPUs".equals(fieldName)) {
                    deserializedRecommendedMachineConfiguration.vCPUs = ResourceRange.fromJson(reader);
                    continue;
                }
                if ("memory".equals(fieldName)) {
                    deserializedRecommendedMachineConfiguration.memory = ResourceRange.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecommendedMachineConfiguration;
        });
    }
}

