/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.DiskEncryptionSetInner;
import java.io.IOException;
import java.util.List;

public final class DiskEncryptionSetList
implements JsonSerializable<DiskEncryptionSetList> {
    private List<DiskEncryptionSetInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DiskEncryptionSetList.class);

    public List<DiskEncryptionSetInner> value() {
        return this.value;
    }

    public DiskEncryptionSetList withValue(List<DiskEncryptionSetInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public DiskEncryptionSetList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DiskEncryptionSetList"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static DiskEncryptionSetList fromJson(JsonReader jsonReader) throws IOException {
        return (DiskEncryptionSetList)jsonReader.readObject(reader -> {
            DiskEncryptionSetList deserializedDiskEncryptionSetList = new DiskEncryptionSetList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDiskEncryptionSetList.value = value = reader.readArray(reader1 -> DiskEncryptionSetInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDiskEncryptionSetList.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskEncryptionSetList;
        });
    }
}

