/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.BootDiagnosticsInstanceView;
import com.azure.resourcemanager.compute.models.DiskInstanceView;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.MaintenanceRedeployStatus;
import com.azure.resourcemanager.compute.models.VirtualMachineAgentInstanceView;
import com.azure.resourcemanager.compute.models.VirtualMachineExtensionInstanceView;
import com.azure.resourcemanager.compute.models.VirtualMachineHealthStatus;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetVMInstanceViewInner
implements JsonSerializable<VirtualMachineScaleSetVMInstanceViewInner> {
    private Integer platformUpdateDomain;
    private Integer platformFaultDomain;
    private String rdpThumbPrint;
    private VirtualMachineAgentInstanceView vmAgent;
    private MaintenanceRedeployStatus maintenanceRedeployStatus;
    private List<DiskInstanceView> disks;
    private List<VirtualMachineExtensionInstanceView> extensions;
    private VirtualMachineHealthStatus vmHealth;
    private BootDiagnosticsInstanceView bootDiagnostics;
    private List<InstanceViewStatus> statuses;
    private String assignedHost;
    private String placementGroupId;
    private String computerName;
    private String osName;
    private String osVersion;
    private HyperVGeneration hyperVGeneration;

    public Integer platformUpdateDomain() {
        return this.platformUpdateDomain;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withPlatformUpdateDomain(Integer platformUpdateDomain) {
        this.platformUpdateDomain = platformUpdateDomain;
        return this;
    }

    public Integer platformFaultDomain() {
        return this.platformFaultDomain;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withPlatformFaultDomain(Integer platformFaultDomain) {
        this.platformFaultDomain = platformFaultDomain;
        return this;
    }

    public String rdpThumbPrint() {
        return this.rdpThumbPrint;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withRdpThumbPrint(String rdpThumbPrint) {
        this.rdpThumbPrint = rdpThumbPrint;
        return this;
    }

    public VirtualMachineAgentInstanceView vmAgent() {
        return this.vmAgent;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withVmAgent(VirtualMachineAgentInstanceView vmAgent) {
        this.vmAgent = vmAgent;
        return this;
    }

    public MaintenanceRedeployStatus maintenanceRedeployStatus() {
        return this.maintenanceRedeployStatus;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withMaintenanceRedeployStatus(MaintenanceRedeployStatus maintenanceRedeployStatus) {
        this.maintenanceRedeployStatus = maintenanceRedeployStatus;
        return this;
    }

    public List<DiskInstanceView> disks() {
        return this.disks;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withDisks(List<DiskInstanceView> disks) {
        this.disks = disks;
        return this;
    }

    public List<VirtualMachineExtensionInstanceView> extensions() {
        return this.extensions;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withExtensions(List<VirtualMachineExtensionInstanceView> extensions) {
        this.extensions = extensions;
        return this;
    }

    public VirtualMachineHealthStatus vmHealth() {
        return this.vmHealth;
    }

    public BootDiagnosticsInstanceView bootDiagnostics() {
        return this.bootDiagnostics;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withBootDiagnostics(BootDiagnosticsInstanceView bootDiagnostics) {
        this.bootDiagnostics = bootDiagnostics;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public String assignedHost() {
        return this.assignedHost;
    }

    public String placementGroupId() {
        return this.placementGroupId;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withPlacementGroupId(String placementGroupId) {
        this.placementGroupId = placementGroupId;
        return this;
    }

    public String computerName() {
        return this.computerName;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withComputerName(String computerName) {
        this.computerName = computerName;
        return this;
    }

    public String osName() {
        return this.osName;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withOsName(String osName) {
        this.osName = osName;
        return this;
    }

    public String osVersion() {
        return this.osVersion;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withOsVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public VirtualMachineScaleSetVMInstanceViewInner withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public void validate() {
        if (this.vmAgent() != null) {
            this.vmAgent().validate();
        }
        if (this.maintenanceRedeployStatus() != null) {
            this.maintenanceRedeployStatus().validate();
        }
        if (this.disks() != null) {
            this.disks().forEach(e -> e.validate());
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.vmHealth() != null) {
            this.vmHealth().validate();
        }
        if (this.bootDiagnostics() != null) {
            this.bootDiagnostics().validate();
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("platformUpdateDomain", (Number)this.platformUpdateDomain);
        jsonWriter.writeNumberField("platformFaultDomain", (Number)this.platformFaultDomain);
        jsonWriter.writeStringField("rdpThumbPrint", this.rdpThumbPrint);
        jsonWriter.writeJsonField("vmAgent", (JsonSerializable)this.vmAgent);
        jsonWriter.writeJsonField("maintenanceRedeployStatus", (JsonSerializable)this.maintenanceRedeployStatus);
        jsonWriter.writeArrayField("disks", this.disks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("bootDiagnostics", (JsonSerializable)this.bootDiagnostics);
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("placementGroupId", this.placementGroupId);
        jsonWriter.writeStringField("computerName", this.computerName);
        jsonWriter.writeStringField("osName", this.osName);
        jsonWriter.writeStringField("osVersion", this.osVersion);
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetVMInstanceViewInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetVMInstanceViewInner)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMInstanceViewInner deserializedVirtualMachineScaleSetVMInstanceViewInner = new VirtualMachineScaleSetVMInstanceViewInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("platformUpdateDomain".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.platformUpdateDomain = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("platformFaultDomain".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.platformFaultDomain = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("rdpThumbPrint".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.rdpThumbPrint = reader.getString();
                    continue;
                }
                if ("vmAgent".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.vmAgent = VirtualMachineAgentInstanceView.fromJson(reader);
                    continue;
                }
                if ("maintenanceRedeployStatus".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.maintenanceRedeployStatus = MaintenanceRedeployStatus.fromJson(reader);
                    continue;
                }
                if ("disks".equals(fieldName)) {
                    List disks;
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.disks = disks = reader.readArray(reader1 -> DiskInstanceView.fromJson(reader1));
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.extensions = extensions = reader.readArray(reader1 -> VirtualMachineExtensionInstanceView.fromJson(reader1));
                    continue;
                }
                if ("vmHealth".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.vmHealth = VirtualMachineHealthStatus.fromJson(reader);
                    continue;
                }
                if ("bootDiagnostics".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.bootDiagnostics = BootDiagnosticsInstanceView.fromJson(reader);
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List statuses;
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.statuses = statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                if ("assignedHost".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.assignedHost = reader.getString();
                    continue;
                }
                if ("placementGroupId".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.placementGroupId = reader.getString();
                    continue;
                }
                if ("computerName".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.computerName = reader.getString();
                    continue;
                }
                if ("osName".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.osName = reader.getString();
                    continue;
                }
                if ("osVersion".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.osVersion = reader.getString();
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInstanceViewInner.hyperVGeneration = HyperVGeneration.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetVMInstanceViewInner;
        });
    }
}

