/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryIdentifier;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.SharingProfile;
import com.azure.resourcemanager.compute.models.SharingStatus;
import com.azure.resourcemanager.compute.models.SoftDeletePolicy;
import java.io.IOException;

public final class GalleryProperties
implements JsonSerializable<GalleryProperties> {
    private String description;
    private GalleryIdentifier identifier;
    private GalleryProvisioningState provisioningState;
    private SharingProfile sharingProfile;
    private SoftDeletePolicy softDeletePolicy;
    private SharingStatus sharingStatus;

    public String description() {
        return this.description;
    }

    public GalleryProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public GalleryIdentifier identifier() {
        return this.identifier;
    }

    public GalleryProperties withIdentifier(GalleryIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SharingProfile sharingProfile() {
        return this.sharingProfile;
    }

    public GalleryProperties withSharingProfile(SharingProfile sharingProfile) {
        this.sharingProfile = sharingProfile;
        return this;
    }

    public SoftDeletePolicy softDeletePolicy() {
        return this.softDeletePolicy;
    }

    public GalleryProperties withSoftDeletePolicy(SoftDeletePolicy softDeletePolicy) {
        this.softDeletePolicy = softDeletePolicy;
        return this;
    }

    public SharingStatus sharingStatus() {
        return this.sharingStatus;
    }

    public void validate() {
        if (this.identifier() != null) {
            this.identifier().validate();
        }
        if (this.sharingProfile() != null) {
            this.sharingProfile().validate();
        }
        if (this.softDeletePolicy() != null) {
            this.softDeletePolicy().validate();
        }
        if (this.sharingStatus() != null) {
            this.sharingStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("identifier", (JsonSerializable)this.identifier);
        jsonWriter.writeJsonField("sharingProfile", (JsonSerializable)this.sharingProfile);
        jsonWriter.writeJsonField("softDeletePolicy", (JsonSerializable)this.softDeletePolicy);
        return jsonWriter.writeEndObject();
    }

    public static GalleryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryProperties)jsonReader.readObject(reader -> {
            GalleryProperties deserializedGalleryProperties = new GalleryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedGalleryProperties.description = reader.getString();
                    continue;
                }
                if ("identifier".equals(fieldName)) {
                    deserializedGalleryProperties.identifier = GalleryIdentifier.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryProperties.provisioningState = GalleryProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("sharingProfile".equals(fieldName)) {
                    deserializedGalleryProperties.sharingProfile = SharingProfile.fromJson(reader);
                    continue;
                }
                if ("softDeletePolicy".equals(fieldName)) {
                    deserializedGalleryProperties.softDeletePolicy = SoftDeletePolicy.fromJson(reader);
                    continue;
                }
                if ("sharingStatus".equals(fieldName)) {
                    deserializedGalleryProperties.sharingStatus = SharingStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryProperties;
        });
    }
}

