// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes a data disk. */
@Fluent
public final class RestorePointSourceVMDataDisk {
    /*
     * Gets the logical unit number.
     */
    @JsonProperty(value = "lun")
    private Integer lun;

    /*
     * Gets the disk name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Gets the caching type.
     */
    @JsonProperty(value = "caching")
    private CachingTypes caching;

    /*
     * Gets the initial disk size in GB for blank data disks, and the new desired size for existing OS and Data disks.
     */
    @JsonProperty(value = "diskSizeGB")
    private Integer diskSizeGB;

    /*
     * Gets the managed disk details
     */
    @JsonProperty(value = "managedDisk")
    private ManagedDiskParameters managedDisk;

    /*
     * Gets the disk restore point Id.
     */
    @JsonProperty(value = "diskRestorePoint")
    private ApiEntityReference diskRestorePoint;

    /** Creates an instance of RestorePointSourceVMDataDisk class. */
    public RestorePointSourceVMDataDisk() {
    }

    /**
     * Get the lun property: Gets the logical unit number.
     *
     * @return the lun value.
     */
    public Integer lun() {
        return this.lun;
    }

    /**
     * Set the lun property: Gets the logical unit number.
     *
     * @param lun the lun value to set.
     * @return the RestorePointSourceVMDataDisk object itself.
     */
    public RestorePointSourceVMDataDisk withLun(Integer lun) {
        this.lun = lun;
        return this;
    }

    /**
     * Get the name property: Gets the disk name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Gets the disk name.
     *
     * @param name the name value to set.
     * @return the RestorePointSourceVMDataDisk object itself.
     */
    public RestorePointSourceVMDataDisk withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the caching property: Gets the caching type.
     *
     * @return the caching value.
     */
    public CachingTypes caching() {
        return this.caching;
    }

    /**
     * Set the caching property: Gets the caching type.
     *
     * @param caching the caching value to set.
     * @return the RestorePointSourceVMDataDisk object itself.
     */
    public RestorePointSourceVMDataDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    /**
     * Get the diskSizeGB property: Gets the initial disk size in GB for blank data disks, and the new desired size for
     * existing OS and Data disks.
     *
     * @return the diskSizeGB value.
     */
    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    /**
     * Set the diskSizeGB property: Gets the initial disk size in GB for blank data disks, and the new desired size for
     * existing OS and Data disks.
     *
     * @param diskSizeGB the diskSizeGB value to set.
     * @return the RestorePointSourceVMDataDisk object itself.
     */
    public RestorePointSourceVMDataDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    /**
     * Get the managedDisk property: Gets the managed disk details.
     *
     * @return the managedDisk value.
     */
    public ManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    /**
     * Set the managedDisk property: Gets the managed disk details.
     *
     * @param managedDisk the managedDisk value to set.
     * @return the RestorePointSourceVMDataDisk object itself.
     */
    public RestorePointSourceVMDataDisk withManagedDisk(ManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    /**
     * Get the diskRestorePoint property: Gets the disk restore point Id.
     *
     * @return the diskRestorePoint value.
     */
    public ApiEntityReference diskRestorePoint() {
        return this.diskRestorePoint;
    }

    /**
     * Set the diskRestorePoint property: Gets the disk restore point Id.
     *
     * @param diskRestorePoint the diskRestorePoint value to set.
     * @return the RestorePointSourceVMDataDisk object itself.
     */
    public RestorePointSourceVMDataDisk withDiskRestorePoint(ApiEntityReference diskRestorePoint) {
        this.diskRestorePoint = diskRestorePoint;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (managedDisk() != null) {
            managedDisk().validate();
        }
        if (diskRestorePoint() != null) {
            diskRestorePoint().validate();
        }
    }
}
