// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Data used for requesting a SAS. */
@Fluent
public final class GrantAccessData {
    /*
     * The access property.
     */
    @JsonProperty(value = "access", required = true)
    private AccessLevel access;

    /*
     * Time duration in seconds until the SAS access expires.
     */
    @JsonProperty(value = "durationInSeconds", required = true)
    private int durationInSeconds;

    /*
     * Set this flag to true to get additional SAS for VM guest state
     */
    @JsonProperty(value = "getSecureVMGuestStateSAS")
    private Boolean getSecureVMGuestStateSas;

    /** Creates an instance of GrantAccessData class. */
    public GrantAccessData() {
    }

    /**
     * Get the access property: The access property.
     *
     * @return the access value.
     */
    public AccessLevel access() {
        return this.access;
    }

    /**
     * Set the access property: The access property.
     *
     * @param access the access value to set.
     * @return the GrantAccessData object itself.
     */
    public GrantAccessData withAccess(AccessLevel access) {
        this.access = access;
        return this;
    }

    /**
     * Get the durationInSeconds property: Time duration in seconds until the SAS access expires.
     *
     * @return the durationInSeconds value.
     */
    public int durationInSeconds() {
        return this.durationInSeconds;
    }

    /**
     * Set the durationInSeconds property: Time duration in seconds until the SAS access expires.
     *
     * @param durationInSeconds the durationInSeconds value to set.
     * @return the GrantAccessData object itself.
     */
    public GrantAccessData withDurationInSeconds(int durationInSeconds) {
        this.durationInSeconds = durationInSeconds;
        return this;
    }

    /**
     * Get the getSecureVMGuestStateSas property: Set this flag to true to get additional SAS for VM guest state.
     *
     * @return the getSecureVMGuestStateSas value.
     */
    public Boolean getSecureVMGuestStateSas() {
        return this.getSecureVMGuestStateSas;
    }

    /**
     * Set the getSecureVMGuestStateSas property: Set this flag to true to get additional SAS for VM guest state.
     *
     * @param getSecureVMGuestStateSas the getSecureVMGuestStateSas value to set.
     * @return the GrantAccessData object itself.
     */
    public GrantAccessData withGetSecureVMGuestStateSas(Boolean getSecureVMGuestStateSas) {
        this.getSecureVMGuestStateSas = getSecureVMGuestStateSas;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (access() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property access in model GrantAccessData"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GrantAccessData.class);
}
