// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The source for the disk image. */
@Fluent
public final class GalleryDiskImageSource extends GalleryArtifactVersionSource {
    /*
     * The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
     */
    @JsonProperty(value = "uri")
    private String uri;

    /*
     * The Storage Account Id that contains the vhd blob being used as a source for this artifact version.
     */
    @JsonProperty(value = "storageAccountId")
    private String storageAccountId;

    /** Creates an instance of GalleryDiskImageSource class. */
    public GalleryDiskImageSource() {
    }

    /**
     * Get the uri property: The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
     *
     * @return the uri value.
     */
    public String uri() {
        return this.uri;
    }

    /**
     * Set the uri property: The uri of the gallery artifact version source. Currently used to specify vhd/blob source.
     *
     * @param uri the uri value to set.
     * @return the GalleryDiskImageSource object itself.
     */
    public GalleryDiskImageSource withUri(String uri) {
        this.uri = uri;
        return this;
    }

    /**
     * Get the storageAccountId property: The Storage Account Id that contains the vhd blob being used as a source for
     * this artifact version.
     *
     * @return the storageAccountId value.
     */
    public String storageAccountId() {
        return this.storageAccountId;
    }

    /**
     * Set the storageAccountId property: The Storage Account Id that contains the vhd blob being used as a source for
     * this artifact version.
     *
     * @param storageAccountId the storageAccountId value to set.
     * @return the GalleryDiskImageSource object itself.
     */
    public GalleryDiskImageSource withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public GalleryDiskImageSource withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
