// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** This is the disk image base class. */
@Fluent
public class GalleryDiskImage {
    /*
     * This property indicates the size of the VHD to be created.
     */
    @JsonProperty(value = "sizeInGB", access = JsonProperty.Access.WRITE_ONLY)
    private Integer sizeInGB;

    /*
     * The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'
     */
    @JsonProperty(value = "hostCaching")
    private HostCaching hostCaching;

    /*
     * The source for the disk image.
     */
    @JsonProperty(value = "source")
    private GalleryDiskImageSource source;

    /** Creates an instance of GalleryDiskImage class. */
    public GalleryDiskImage() {
    }

    /**
     * Get the sizeInGB property: This property indicates the size of the VHD to be created.
     *
     * @return the sizeInGB value.
     */
    public Integer sizeInGB() {
        return this.sizeInGB;
    }

    /**
     * Get the hostCaching property: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'.
     *
     * @return the hostCaching value.
     */
    public HostCaching hostCaching() {
        return this.hostCaching;
    }

    /**
     * Set the hostCaching property: The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'.
     *
     * @param hostCaching the hostCaching value to set.
     * @return the GalleryDiskImage object itself.
     */
    public GalleryDiskImage withHostCaching(HostCaching hostCaching) {
        this.hostCaching = hostCaching;
        return this;
    }

    /**
     * Get the source property: The source for the disk image.
     *
     * @return the source value.
     */
    public GalleryDiskImageSource source() {
        return this.source;
    }

    /**
     * Set the source property: The source for the disk image.
     *
     * @param source the source value to set.
     * @return the GalleryDiskImage object itself.
     */
    public GalleryDiskImage withSource(GalleryDiskImageSource source) {
        this.source = source;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (source() != null) {
            source().validate();
        }
    }
}
