// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.GalleryApplicationVersionInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The List Gallery Application version operation response. */
@Fluent
public final class GalleryApplicationVersionList {
    /*
     * A list of gallery Application Versions.
     */
    @JsonProperty(value = "value", required = true)
    private List<GalleryApplicationVersionInner> value;

    /*
     * The uri to fetch the next page of gallery Application Versions. Call ListNext() with this to fetch the next page
     * of gallery Application Versions.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of GalleryApplicationVersionList class. */
    public GalleryApplicationVersionList() {
    }

    /**
     * Get the value property: A list of gallery Application Versions.
     *
     * @return the value value.
     */
    public List<GalleryApplicationVersionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of gallery Application Versions.
     *
     * @param value the value value to set.
     * @return the GalleryApplicationVersionList object itself.
     */
    public GalleryApplicationVersionList withValue(List<GalleryApplicationVersionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of gallery Application Versions. Call ListNext() with
     * this to fetch the next page of gallery Application Versions.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of gallery Application Versions. Call ListNext() with
     * this to fetch the next page of gallery Application Versions.
     *
     * @param nextLink the nextLink value to set.
     * @return the GalleryApplicationVersionList object itself.
     */
    public GalleryApplicationVersionList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property value in model GalleryApplicationVersionList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationVersionList.class);
}
