// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The instance view of a disk restore point. */
@Fluent
public final class DiskRestorePointInstanceView {
    /*
     * Disk restore point Id.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The disk restore point replication status information.
     */
    @JsonProperty(value = "replicationStatus")
    private DiskRestorePointReplicationStatus replicationStatus;

    /** Creates an instance of DiskRestorePointInstanceView class. */
    public DiskRestorePointInstanceView() {
    }

    /**
     * Get the id property: Disk restore point Id.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Disk restore point Id.
     *
     * @param id the id value to set.
     * @return the DiskRestorePointInstanceView object itself.
     */
    public DiskRestorePointInstanceView withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the replicationStatus property: The disk restore point replication status information.
     *
     * @return the replicationStatus value.
     */
    public DiskRestorePointReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    /**
     * Set the replicationStatus property: The disk restore point replication status information.
     *
     * @param replicationStatus the replicationStatus value to set.
     * @return the DiskRestorePointInstanceView object itself.
     */
    public DiskRestorePointInstanceView withReplicationStatus(DiskRestorePointReplicationStatus replicationStatus) {
        this.replicationStatus = replicationStatus;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (replicationStatus() != null) {
            replicationStatus().validate();
        }
    }
}
