/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.SslProtocol;
import com.azure.resourcemanager.cdn.models.SslProtocolOperator;
import com.azure.resourcemanager.cdn.models.Transform;
import java.io.IOException;
import java.util.List;

public final class SslProtocolMatchConditionParameters
implements JsonSerializable<SslProtocolMatchConditionParameters> {
    private String typeName = "DeliveryRuleSslProtocolConditionParameters";
    private SslProtocolOperator operator;
    private Boolean negateCondition;
    private List<SslProtocol> matchValues;
    private List<Transform> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(SslProtocolMatchConditionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public SslProtocolMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public SslProtocolOperator operator() {
        return this.operator;
    }

    public SslProtocolMatchConditionParameters withOperator(SslProtocolOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public SslProtocolMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<SslProtocol> matchValues() {
        return this.matchValues;
    }

    public SslProtocolMatchConditionParameters withMatchValues(List<SslProtocol> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public SslProtocolMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model SslProtocolMatchConditionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static SslProtocolMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SslProtocolMatchConditionParameters)jsonReader.readObject(reader -> {
            SslProtocolMatchConditionParameters deserializedSslProtocolMatchConditionParameters = new SslProtocolMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedSslProtocolMatchConditionParameters.operator = SslProtocolOperator.fromString(reader.getString());
                    continue;
                }
                if ("negateCondition".equals(fieldName)) {
                    deserializedSslProtocolMatchConditionParameters.negateCondition = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List matchValues;
                    deserializedSslProtocolMatchConditionParameters.matchValues = matchValues = reader.readArray(reader1 -> SslProtocol.fromString(reader1.getString()));
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List transforms;
                    deserializedSslProtocolMatchConditionParameters.transforms = transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSslProtocolMatchConditionParameters;
        });
    }
}

