/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.FunctionsDeployment;
import com.azure.resourcemanager.appservice.models.FunctionsRuntime;
import com.azure.resourcemanager.appservice.models.FunctionsScaleAndConcurrency;
import java.io.IOException;

public final class FunctionAppConfig
implements JsonSerializable<FunctionAppConfig> {
    private FunctionsDeployment deployment;
    private FunctionsRuntime runtime;
    private FunctionsScaleAndConcurrency scaleAndConcurrency;

    public FunctionsDeployment deployment() {
        return this.deployment;
    }

    public FunctionAppConfig withDeployment(FunctionsDeployment deployment) {
        this.deployment = deployment;
        return this;
    }

    public FunctionsRuntime runtime() {
        return this.runtime;
    }

    public FunctionAppConfig withRuntime(FunctionsRuntime runtime) {
        this.runtime = runtime;
        return this;
    }

    public FunctionsScaleAndConcurrency scaleAndConcurrency() {
        return this.scaleAndConcurrency;
    }

    public FunctionAppConfig withScaleAndConcurrency(FunctionsScaleAndConcurrency scaleAndConcurrency) {
        this.scaleAndConcurrency = scaleAndConcurrency;
        return this;
    }

    public void validate() {
        if (this.deployment() != null) {
            this.deployment().validate();
        }
        if (this.runtime() != null) {
            this.runtime().validate();
        }
        if (this.scaleAndConcurrency() != null) {
            this.scaleAndConcurrency().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("deployment", (JsonSerializable)this.deployment);
        jsonWriter.writeJsonField("runtime", (JsonSerializable)this.runtime);
        jsonWriter.writeJsonField("scaleAndConcurrency", (JsonSerializable)this.scaleAndConcurrency);
        return jsonWriter.writeEndObject();
    }

    public static FunctionAppConfig fromJson(JsonReader jsonReader) throws IOException {
        return (FunctionAppConfig)jsonReader.readObject(reader -> {
            FunctionAppConfig deserializedFunctionAppConfig = new FunctionAppConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deployment".equals(fieldName)) {
                    deserializedFunctionAppConfig.deployment = FunctionsDeployment.fromJson(reader);
                    continue;
                }
                if ("runtime".equals(fieldName)) {
                    deserializedFunctionAppConfig.runtime = FunctionsRuntime.fromJson(reader);
                    continue;
                }
                if ("scaleAndConcurrency".equals(fieldName)) {
                    deserializedFunctionAppConfig.scaleAndConcurrency = FunctionsScaleAndConcurrency.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFunctionAppConfig;
        });
    }
}

