/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowTriggerProperties;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import com.azure.resourcemanager.appservice.models.WorkflowTriggerProvisioningState;
import com.azure.resourcemanager.appservice.models.WorkflowTriggerRecurrence;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class WorkflowTriggerInner
extends SubResource {
    private WorkflowTriggerProperties innerProperties;
    private String name;
    private String type;

    private WorkflowTriggerProperties innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public WorkflowTriggerInner withId(String id) {
        super.withId(id);
        return this;
    }

    public WorkflowTriggerProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    public OffsetDateTime changedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().changedTime();
    }

    public WorkflowState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public WorkflowStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public OffsetDateTime lastExecutionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastExecutionTime();
    }

    public OffsetDateTime nextExecutionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().nextExecutionTime();
    }

    public WorkflowTriggerRecurrence recurrence() {
        return this.innerProperties() == null ? null : this.innerProperties().recurrence();
    }

    public ResourceReference workflow() {
        return this.innerProperties() == null ? null : this.innerProperties().workflow();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static WorkflowTriggerInner fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowTriggerInner)((Object)jsonReader.readObject(reader -> {
            WorkflowTriggerInner deserializedWorkflowTriggerInner = new WorkflowTriggerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedWorkflowTriggerInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedWorkflowTriggerInner.innerProperties = WorkflowTriggerProperties.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkflowTriggerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkflowTriggerInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowTriggerInner;
        }));
    }
}

