/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ServerFarmRdpDetailsInner
implements JsonSerializable<ServerFarmRdpDetailsInner> {
    private String rdpPassword;
    private OffsetDateTime rdpPasswordExpiry;

    public String rdpPassword() {
        return this.rdpPassword;
    }

    public ServerFarmRdpDetailsInner withRdpPassword(String rdpPassword) {
        this.rdpPassword = rdpPassword;
        return this;
    }

    public OffsetDateTime rdpPasswordExpiry() {
        return this.rdpPasswordExpiry;
    }

    public ServerFarmRdpDetailsInner withRdpPasswordExpiry(OffsetDateTime rdpPasswordExpiry) {
        this.rdpPasswordExpiry = rdpPasswordExpiry;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("rdpPassword", this.rdpPassword);
        jsonWriter.writeStringField("rdpPasswordExpiry", this.rdpPasswordExpiry == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.rdpPasswordExpiry));
        return jsonWriter.writeEndObject();
    }

    public static ServerFarmRdpDetailsInner fromJson(JsonReader jsonReader) throws IOException {
        return (ServerFarmRdpDetailsInner)jsonReader.readObject(reader -> {
            ServerFarmRdpDetailsInner deserializedServerFarmRdpDetailsInner = new ServerFarmRdpDetailsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rdpPassword".equals(fieldName)) {
                    deserializedServerFarmRdpDetailsInner.rdpPassword = reader.getString();
                    continue;
                }
                if ("rdpPasswordExpiry".equals(fieldName)) {
                    deserializedServerFarmRdpDetailsInner.rdpPasswordExpiry = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerFarmRdpDetailsInner;
        });
    }
}

