/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.KubeEnvironmentPatchResourceProperties;
import com.azure.resourcemanager.appservice.models.AppLogsConfiguration;
import com.azure.resourcemanager.appservice.models.ArcConfiguration;
import com.azure.resourcemanager.appservice.models.ContainerAppsConfiguration;
import com.azure.resourcemanager.appservice.models.KubeEnvironmentProvisioningState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class KubeEnvironmentPatchResource
extends ProxyOnlyResource {
    private KubeEnvironmentPatchResourceProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private KubeEnvironmentPatchResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public KubeEnvironmentPatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public KubeEnvironmentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String deploymentErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentErrors();
    }

    public Boolean internalLoadBalancerEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().internalLoadBalancerEnabled();
    }

    public KubeEnvironmentPatchResource withInternalLoadBalancerEnabled(Boolean internalLoadBalancerEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentPatchResourceProperties();
        }
        this.innerProperties().withInternalLoadBalancerEnabled(internalLoadBalancerEnabled);
        return this;
    }

    public String defaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDomain();
    }

    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    public KubeEnvironmentPatchResource withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentPatchResourceProperties();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    public ArcConfiguration arcConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().arcConfiguration();
    }

    public KubeEnvironmentPatchResource withArcConfiguration(ArcConfiguration arcConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentPatchResourceProperties();
        }
        this.innerProperties().withArcConfiguration(arcConfiguration);
        return this;
    }

    public AppLogsConfiguration appLogsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().appLogsConfiguration();
    }

    public KubeEnvironmentPatchResource withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentPatchResourceProperties();
        }
        this.innerProperties().withAppLogsConfiguration(appLogsConfiguration);
        return this;
    }

    public ContainerAppsConfiguration containerAppsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().containerAppsConfiguration();
    }

    public KubeEnvironmentPatchResource withContainerAppsConfiguration(ContainerAppsConfiguration containerAppsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentPatchResourceProperties();
        }
        this.innerProperties().withContainerAppsConfiguration(containerAppsConfiguration);
        return this;
    }

    public String aksResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().aksResourceId();
    }

    public KubeEnvironmentPatchResource withAksResourceId(String aksResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentPatchResourceProperties();
        }
        this.innerProperties().withAksResourceId(aksResourceId);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static KubeEnvironmentPatchResource fromJson(JsonReader jsonReader) throws IOException {
        return (KubeEnvironmentPatchResource)((Object)jsonReader.readObject(reader -> {
            KubeEnvironmentPatchResource deserializedKubeEnvironmentPatchResource = new KubeEnvironmentPatchResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResource.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResource.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedKubeEnvironmentPatchResource.innerProperties = KubeEnvironmentPatchResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubeEnvironmentPatchResource;
        }));
    }
}

