/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.AzureResourceErrorInfo;
import java.io.IOException;
import java.util.List;

public class Expression
implements JsonSerializable<Expression> {
    private String text;
    private Object value;
    private List<Expression> subexpressions;
    private AzureResourceErrorInfo error;

    public String text() {
        return this.text;
    }

    public Expression withText(String text) {
        this.text = text;
        return this;
    }

    public Object value() {
        return this.value;
    }

    public Expression withValue(Object value) {
        this.value = value;
        return this;
    }

    public List<Expression> subexpressions() {
        return this.subexpressions;
    }

    public Expression withSubexpressions(List<Expression> subexpressions) {
        this.subexpressions = subexpressions;
        return this;
    }

    public AzureResourceErrorInfo error() {
        return this.error;
    }

    public Expression withError(AzureResourceErrorInfo error) {
        this.error = error;
        return this;
    }

    public void validate() {
        if (this.subexpressions() != null) {
            this.subexpressions().forEach(e -> e.validate());
        }
        if (this.error() != null) {
            this.error().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        if (this.value != null) {
            jsonWriter.writeUntypedField("value", this.value);
        }
        jsonWriter.writeArrayField("subexpressions", this.subexpressions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static Expression fromJson(JsonReader jsonReader) throws IOException {
        return (Expression)jsonReader.readObject(reader -> {
            Expression deserializedExpression = new Expression();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedExpression.text = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedExpression.value = reader.readUntyped();
                    continue;
                }
                if ("subexpressions".equals(fieldName)) {
                    List subexpressions;
                    deserializedExpression.subexpressions = subexpressions = reader.readArray(reader1 -> Expression.fromJson(reader1));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedExpression.error = AzureResourceErrorInfo.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpression;
        });
    }
}

