/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ContainerCpuUsage
implements JsonSerializable<ContainerCpuUsage> {
    private Long totalUsage;
    private List<Long> perCpuUsage;
    private Long kernelModeUsage;
    private Long userModeUsage;

    public Long totalUsage() {
        return this.totalUsage;
    }

    public ContainerCpuUsage withTotalUsage(Long totalUsage) {
        this.totalUsage = totalUsage;
        return this;
    }

    public List<Long> perCpuUsage() {
        return this.perCpuUsage;
    }

    public ContainerCpuUsage withPerCpuUsage(List<Long> perCpuUsage) {
        this.perCpuUsage = perCpuUsage;
        return this;
    }

    public Long kernelModeUsage() {
        return this.kernelModeUsage;
    }

    public ContainerCpuUsage withKernelModeUsage(Long kernelModeUsage) {
        this.kernelModeUsage = kernelModeUsage;
        return this;
    }

    public Long userModeUsage() {
        return this.userModeUsage;
    }

    public ContainerCpuUsage withUserModeUsage(Long userModeUsage) {
        this.userModeUsage = userModeUsage;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("totalUsage", (Number)this.totalUsage);
        jsonWriter.writeArrayField("perCpuUsage", this.perCpuUsage, (writer, element) -> writer.writeLong(element.longValue()));
        jsonWriter.writeNumberField("kernelModeUsage", (Number)this.kernelModeUsage);
        jsonWriter.writeNumberField("userModeUsage", (Number)this.userModeUsage);
        return jsonWriter.writeEndObject();
    }

    public static ContainerCpuUsage fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerCpuUsage)jsonReader.readObject(reader -> {
            ContainerCpuUsage deserializedContainerCpuUsage = new ContainerCpuUsage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("totalUsage".equals(fieldName)) {
                    deserializedContainerCpuUsage.totalUsage = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("perCpuUsage".equals(fieldName)) {
                    List perCpuUsage;
                    deserializedContainerCpuUsage.perCpuUsage = perCpuUsage = reader.readArray(reader1 -> reader1.getLong());
                    continue;
                }
                if ("kernelModeUsage".equals(fieldName)) {
                    deserializedContainerCpuUsage.kernelModeUsage = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("userModeUsage".equals(fieldName)) {
                    deserializedContainerCpuUsage.userModeUsage = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerCpuUsage;
        });
    }
}

