/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.CsmOperationDescriptionProperties;
import com.azure.resourcemanager.appservice.models.CsmOperationDisplay;
import java.io.IOException;

public final class CsmOperationDescriptionInner
implements JsonSerializable<CsmOperationDescriptionInner> {
    private String name;
    private Boolean isDataAction;
    private CsmOperationDisplay display;
    private String origin;
    private CsmOperationDescriptionProperties properties;

    public String name() {
        return this.name;
    }

    public CsmOperationDescriptionInner withName(String name) {
        this.name = name;
        return this;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public CsmOperationDescriptionInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public CsmOperationDisplay display() {
        return this.display;
    }

    public CsmOperationDescriptionInner withDisplay(CsmOperationDisplay display) {
        this.display = display;
        return this;
    }

    public String origin() {
        return this.origin;
    }

    public CsmOperationDescriptionInner withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public CsmOperationDescriptionProperties properties() {
        return this.properties;
    }

    public CsmOperationDescriptionInner withProperties(CsmOperationDescriptionProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        jsonWriter.writeJsonField("display", (JsonSerializable)this.display);
        jsonWriter.writeStringField("origin", this.origin);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static CsmOperationDescriptionInner fromJson(JsonReader jsonReader) throws IOException {
        return (CsmOperationDescriptionInner)jsonReader.readObject(reader -> {
            CsmOperationDescriptionInner deserializedCsmOperationDescriptionInner = new CsmOperationDescriptionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCsmOperationDescriptionInner.name = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedCsmOperationDescriptionInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedCsmOperationDescriptionInner.display = CsmOperationDisplay.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedCsmOperationDescriptionInner.origin = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCsmOperationDescriptionInner.properties = CsmOperationDescriptionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCsmOperationDescriptionInner;
        });
    }
}

