/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResourceConfig
implements JsonSerializable<ResourceConfig> {
    private Double cpu;
    private String memory;

    public Double cpu() {
        return this.cpu;
    }

    public ResourceConfig withCpu(Double cpu) {
        this.cpu = cpu;
        return this;
    }

    public String memory() {
        return this.memory;
    }

    public ResourceConfig withMemory(String memory) {
        this.memory = memory;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("cpu", (Number)this.cpu);
        jsonWriter.writeStringField("memory", this.memory);
        return jsonWriter.writeEndObject();
    }

    public static ResourceConfig fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceConfig)jsonReader.readObject(reader -> {
            ResourceConfig deserializedResourceConfig = new ResourceConfig();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cpu".equals(fieldName)) {
                    deserializedResourceConfig.cpu = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("memory".equals(fieldName)) {
                    deserializedResourceConfig.memory = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceConfig;
        });
    }
}

