/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.TriggeredJobRun;
import com.azure.resourcemanager.appservice.models.WebJobType;
import java.io.IOException;
import java.util.Map;

public final class TriggeredWebJobProperties
implements JsonSerializable<TriggeredWebJobProperties> {
    private TriggeredJobRun latestRun;
    private String historyUrl;
    private String schedulerLogsUrl;
    private String runCommand;
    private String url;
    private String extraInfoUrl;
    private WebJobType webJobType;
    private String error;
    private Boolean usingSdk;
    private String publicNetworkAccess;
    private Boolean storageAccountRequired;
    private Map<String, Object> settings;

    public TriggeredJobRun latestRun() {
        return this.latestRun;
    }

    public TriggeredWebJobProperties withLatestRun(TriggeredJobRun latestRun) {
        this.latestRun = latestRun;
        return this;
    }

    public String historyUrl() {
        return this.historyUrl;
    }

    public TriggeredWebJobProperties withHistoryUrl(String historyUrl) {
        this.historyUrl = historyUrl;
        return this;
    }

    public String schedulerLogsUrl() {
        return this.schedulerLogsUrl;
    }

    public TriggeredWebJobProperties withSchedulerLogsUrl(String schedulerLogsUrl) {
        this.schedulerLogsUrl = schedulerLogsUrl;
        return this;
    }

    public String runCommand() {
        return this.runCommand;
    }

    public TriggeredWebJobProperties withRunCommand(String runCommand) {
        this.runCommand = runCommand;
        return this;
    }

    public String url() {
        return this.url;
    }

    public TriggeredWebJobProperties withUrl(String url) {
        this.url = url;
        return this;
    }

    public String extraInfoUrl() {
        return this.extraInfoUrl;
    }

    public TriggeredWebJobProperties withExtraInfoUrl(String extraInfoUrl) {
        this.extraInfoUrl = extraInfoUrl;
        return this;
    }

    public WebJobType webJobType() {
        return this.webJobType;
    }

    public TriggeredWebJobProperties withWebJobType(WebJobType webJobType) {
        this.webJobType = webJobType;
        return this;
    }

    public String error() {
        return this.error;
    }

    public TriggeredWebJobProperties withError(String error) {
        this.error = error;
        return this;
    }

    public Boolean usingSdk() {
        return this.usingSdk;
    }

    public TriggeredWebJobProperties withUsingSdk(Boolean usingSdk) {
        this.usingSdk = usingSdk;
        return this;
    }

    public String publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public TriggeredWebJobProperties withPublicNetworkAccess(String publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean storageAccountRequired() {
        return this.storageAccountRequired;
    }

    public TriggeredWebJobProperties withStorageAccountRequired(Boolean storageAccountRequired) {
        this.storageAccountRequired = storageAccountRequired;
        return this;
    }

    public Map<String, Object> settings() {
        return this.settings;
    }

    public TriggeredWebJobProperties withSettings(Map<String, Object> settings) {
        this.settings = settings;
        return this;
    }

    public void validate() {
        if (this.latestRun() != null) {
            this.latestRun().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("latest_run", (JsonSerializable)this.latestRun);
        jsonWriter.writeStringField("history_url", this.historyUrl);
        jsonWriter.writeStringField("scheduler_logs_url", this.schedulerLogsUrl);
        jsonWriter.writeStringField("run_command", this.runCommand);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("extra_info_url", this.extraInfoUrl);
        jsonWriter.writeStringField("web_job_type", this.webJobType == null ? null : this.webJobType.toString());
        jsonWriter.writeStringField("error", this.error);
        jsonWriter.writeBooleanField("using_sdk", this.usingSdk);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess);
        jsonWriter.writeBooleanField("storageAccountRequired", this.storageAccountRequired);
        jsonWriter.writeMapField("settings", this.settings, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static TriggeredWebJobProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TriggeredWebJobProperties)jsonReader.readObject(reader -> {
            TriggeredWebJobProperties deserializedTriggeredWebJobProperties = new TriggeredWebJobProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("latest_run".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.latestRun = TriggeredJobRun.fromJson(reader);
                    continue;
                }
                if ("history_url".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.historyUrl = reader.getString();
                    continue;
                }
                if ("scheduler_logs_url".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.schedulerLogsUrl = reader.getString();
                    continue;
                }
                if ("run_command".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.runCommand = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.url = reader.getString();
                    continue;
                }
                if ("extra_info_url".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.extraInfoUrl = reader.getString();
                    continue;
                }
                if ("web_job_type".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.webJobType = WebJobType.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.error = reader.getString();
                    continue;
                }
                if ("using_sdk".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.usingSdk = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.publicNetworkAccess = reader.getString();
                    continue;
                }
                if ("storageAccountRequired".equals(fieldName)) {
                    deserializedTriggeredWebJobProperties.storageAccountRequired = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    Map settings;
                    deserializedTriggeredWebJobProperties.settings = settings = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTriggeredWebJobProperties;
        });
    }
}

