/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.resourcemanager.appservice.models.FlowAccessControlConfiguration;
import com.azure.resourcemanager.appservice.models.FlowEndpointsConfiguration;
import com.azure.resourcemanager.appservice.models.Kind;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowParameter;
import com.azure.resourcemanager.appservice.models.WorkflowProvisioningState;
import com.azure.resourcemanager.appservice.models.WorkflowSku;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WorkflowProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private WorkflowProvisioningState provisioningState;
    @JsonProperty(value="createdTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdTime;
    @JsonProperty(value="changedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime changedTime;
    @JsonProperty(value="state")
    private WorkflowState state;
    @JsonProperty(value="version", access=JsonProperty.Access.WRITE_ONLY)
    private String version;
    @JsonProperty(value="accessEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String accessEndpoint;
    @JsonProperty(value="endpointsConfiguration")
    private FlowEndpointsConfiguration endpointsConfiguration;
    @JsonProperty(value="accessControl")
    private FlowAccessControlConfiguration accessControl;
    @JsonProperty(value="sku", access=JsonProperty.Access.WRITE_ONLY)
    private WorkflowSku sku;
    @JsonProperty(value="integrationAccount")
    private ResourceReference integrationAccount;
    @JsonProperty(value="integrationServiceEnvironment")
    private ResourceReference integrationServiceEnvironment;
    @JsonProperty(value="definition")
    private Object definition;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, WorkflowParameter> parameters;
    @JsonProperty(value="kind")
    private Kind kind;

    public WorkflowProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime changedTime() {
        return this.changedTime;
    }

    public WorkflowState state() {
        return this.state;
    }

    public WorkflowProperties withState(WorkflowState state) {
        this.state = state;
        return this;
    }

    public String version() {
        return this.version;
    }

    public String accessEndpoint() {
        return this.accessEndpoint;
    }

    public FlowEndpointsConfiguration endpointsConfiguration() {
        return this.endpointsConfiguration;
    }

    public WorkflowProperties withEndpointsConfiguration(FlowEndpointsConfiguration endpointsConfiguration) {
        this.endpointsConfiguration = endpointsConfiguration;
        return this;
    }

    public FlowAccessControlConfiguration accessControl() {
        return this.accessControl;
    }

    public WorkflowProperties withAccessControl(FlowAccessControlConfiguration accessControl) {
        this.accessControl = accessControl;
        return this;
    }

    public WorkflowSku sku() {
        return this.sku;
    }

    public ResourceReference integrationAccount() {
        return this.integrationAccount;
    }

    public WorkflowProperties withIntegrationAccount(ResourceReference integrationAccount) {
        this.integrationAccount = integrationAccount;
        return this;
    }

    public ResourceReference integrationServiceEnvironment() {
        return this.integrationServiceEnvironment;
    }

    public WorkflowProperties withIntegrationServiceEnvironment(ResourceReference integrationServiceEnvironment) {
        this.integrationServiceEnvironment = integrationServiceEnvironment;
        return this;
    }

    public Object definition() {
        return this.definition;
    }

    public WorkflowProperties withDefinition(Object definition) {
        this.definition = definition;
        return this;
    }

    public Map<String, WorkflowParameter> parameters() {
        return this.parameters;
    }

    public WorkflowProperties withParameters(Map<String, WorkflowParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Kind kind() {
        return this.kind;
    }

    public WorkflowProperties withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    public void validate() {
        if (this.endpointsConfiguration() != null) {
            this.endpointsConfiguration().validate();
        }
        if (this.accessControl() != null) {
            this.accessControl().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.integrationAccount() != null) {
            this.integrationAccount().validate();
        }
        if (this.integrationServiceEnvironment() != null) {
            this.integrationServiceEnvironment().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }
}

