/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.CustomScaleRule;
import com.azure.resourcemanager.appservice.models.HttpScaleRule;
import com.azure.resourcemanager.appservice.models.QueueScaleRule;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ScaleRule {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ScaleRule.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="azureQueue")
    private QueueScaleRule azureQueue;
    @JsonProperty(value="custom")
    private CustomScaleRule custom;
    @JsonProperty(value="http")
    private HttpScaleRule http;

    public String name() {
        return this.name;
    }

    public ScaleRule withName(String name) {
        this.name = name;
        return this;
    }

    public QueueScaleRule azureQueue() {
        return this.azureQueue;
    }

    public ScaleRule withAzureQueue(QueueScaleRule azureQueue) {
        this.azureQueue = azureQueue;
        return this;
    }

    public CustomScaleRule custom() {
        return this.custom;
    }

    public ScaleRule withCustom(CustomScaleRule custom) {
        this.custom = custom;
        return this;
    }

    public HttpScaleRule http() {
        return this.http;
    }

    public ScaleRule withHttp(HttpScaleRule http) {
        this.http = http;
        return this;
    }

    public void validate() {
        if (this.azureQueue() != null) {
            this.azureQueue().validate();
        }
        if (this.custom() != null) {
            this.custom().validate();
        }
        if (this.http() != null) {
            this.http().validate();
        }
    }
}

