/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.IngressTransportMethod;
import com.azure.resourcemanager.appservice.models.TrafficWeight;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Ingress {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Ingress.class);
    @JsonProperty(value="fqdn", access=JsonProperty.Access.WRITE_ONLY)
    private String fqdn;
    @JsonProperty(value="external")
    private Boolean external;
    @JsonProperty(value="targetPort")
    private Integer targetPort;
    @JsonProperty(value="transport")
    private IngressTransportMethod transport;
    @JsonProperty(value="traffic")
    private List<TrafficWeight> traffic;
    @JsonProperty(value="allowInsecure")
    private Boolean allowInsecure;

    public String fqdn() {
        return this.fqdn;
    }

    public Boolean external() {
        return this.external;
    }

    public Ingress withExternal(Boolean external) {
        this.external = external;
        return this;
    }

    public Integer targetPort() {
        return this.targetPort;
    }

    public Ingress withTargetPort(Integer targetPort) {
        this.targetPort = targetPort;
        return this;
    }

    public IngressTransportMethod transport() {
        return this.transport;
    }

    public Ingress withTransport(IngressTransportMethod transport) {
        this.transport = transport;
        return this;
    }

    public List<TrafficWeight> traffic() {
        return this.traffic;
    }

    public Ingress withTraffic(List<TrafficWeight> traffic) {
        this.traffic = traffic;
        return this;
    }

    public Boolean allowInsecure() {
        return this.allowInsecure;
    }

    public Ingress withAllowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    public void validate() {
        if (this.traffic() != null) {
            this.traffic().forEach(e -> e.validate());
        }
    }
}

