/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ContainerResources;
import com.azure.resourcemanager.appservice.models.EnvironmentVar;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Container {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Container.class);
    @JsonProperty(value="image")
    private String image;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="command")
    private List<String> command;
    @JsonProperty(value="args")
    private List<String> args;
    @JsonProperty(value="env")
    private List<EnvironmentVar> env;
    @JsonProperty(value="resources")
    private ContainerResources resources;

    public String image() {
        return this.image;
    }

    public Container withImage(String image) {
        this.image = image;
        return this;
    }

    public String name() {
        return this.name;
    }

    public Container withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public Container withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<String> args() {
        return this.args;
    }

    public Container withArgs(List<String> args) {
        this.args = args;
        return this;
    }

    public List<EnvironmentVar> env() {
        return this.env;
    }

    public Container withEnv(List<EnvironmentVar> env) {
        this.env = env;
        return this;
    }

    public ContainerResources resources() {
        return this.resources;
    }

    public Container withResources(ContainerResources resources) {
        this.resources = resources;
        return this;
    }

    public void validate() {
        if (this.env() != null) {
            this.env().forEach(e -> e.validate());
        }
        if (this.resources() != null) {
            this.resources().validate();
        }
    }
}

