/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ActiveRevisionsMode;
import com.azure.resourcemanager.appservice.models.Ingress;
import com.azure.resourcemanager.appservice.models.RegistryCredentials;
import com.azure.resourcemanager.appservice.models.Secret;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Configuration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Configuration.class);
    @JsonProperty(value="secrets")
    private List<Secret> secrets;
    @JsonProperty(value="activeRevisionsMode")
    private ActiveRevisionsMode activeRevisionsMode;
    @JsonProperty(value="ingress")
    private Ingress ingress;
    @JsonProperty(value="registries")
    private List<RegistryCredentials> registries;

    public List<Secret> secrets() {
        return this.secrets;
    }

    public Configuration withSecrets(List<Secret> secrets) {
        this.secrets = secrets;
        return this;
    }

    public ActiveRevisionsMode activeRevisionsMode() {
        return this.activeRevisionsMode;
    }

    public Configuration withActiveRevisionsMode(ActiveRevisionsMode activeRevisionsMode) {
        this.activeRevisionsMode = activeRevisionsMode;
        return this;
    }

    public Ingress ingress() {
        return this.ingress;
    }

    public Configuration withIngress(Ingress ingress) {
        this.ingress = ingress;
        return this;
    }

    public List<RegistryCredentials> registries() {
        return this.registries;
    }

    public Configuration withRegistries(List<RegistryCredentials> registries) {
        this.registries = registries;
        return this;
    }

    public void validate() {
        if (this.secrets() != null) {
            this.secrets().forEach(e -> e.validate());
        }
        if (this.ingress() != null) {
            this.ingress().validate();
        }
        if (this.registries() != null) {
            this.registries().forEach(e -> e.validate());
        }
    }
}

