/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.DefaultAuthorizationPolicy;
import com.azure.resourcemanager.appservice.models.JwtClaimChecks;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AzureActiveDirectoryValidation {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AzureActiveDirectoryValidation.class);
    @JsonProperty(value="jwtClaimChecks")
    private JwtClaimChecks jwtClaimChecks;
    @JsonProperty(value="allowedAudiences")
    private List<String> allowedAudiences;
    @JsonProperty(value="defaultAuthorizationPolicy")
    private DefaultAuthorizationPolicy defaultAuthorizationPolicy;

    public JwtClaimChecks jwtClaimChecks() {
        return this.jwtClaimChecks;
    }

    public AzureActiveDirectoryValidation withJwtClaimChecks(JwtClaimChecks jwtClaimChecks) {
        this.jwtClaimChecks = jwtClaimChecks;
        return this;
    }

    public List<String> allowedAudiences() {
        return this.allowedAudiences;
    }

    public AzureActiveDirectoryValidation withAllowedAudiences(List<String> allowedAudiences) {
        this.allowedAudiences = allowedAudiences;
        return this;
    }

    public DefaultAuthorizationPolicy defaultAuthorizationPolicy() {
        return this.defaultAuthorizationPolicy;
    }

    public AzureActiveDirectoryValidation withDefaultAuthorizationPolicy(DefaultAuthorizationPolicy defaultAuthorizationPolicy) {
        this.defaultAuthorizationPolicy = defaultAuthorizationPolicy;
        return this;
    }

    public void validate() {
        if (this.jwtClaimChecks() != null) {
            this.jwtClaimChecks().validate();
        }
        if (this.defaultAuthorizationPolicy() != null) {
            this.defaultAuthorizationPolicy().validate();
        }
    }
}

