/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.ProcessModuleInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessThreadInfoInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ProcessInfoProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ProcessInfoProperties.class);
    @JsonProperty(value="identifier", access=JsonProperty.Access.WRITE_ONLY)
    private Integer identifier;
    @JsonProperty(value="deployment_name")
    private String deploymentName;
    @JsonProperty(value="href")
    private String href;
    @JsonProperty(value="minidump")
    private String minidump;
    @JsonProperty(value="is_profile_running")
    private Boolean isProfileRunning;
    @JsonProperty(value="is_iis_profile_running")
    private Boolean isIisProfileRunning;
    @JsonProperty(value="iis_profile_timeout_in_seconds")
    private Double iisProfileTimeoutInSeconds;
    @JsonProperty(value="parent")
    private String parent;
    @JsonProperty(value="children")
    private List<String> children;
    @JsonProperty(value="threads")
    private List<ProcessThreadInfoInner> threads;
    @JsonProperty(value="open_file_handles")
    private List<String> openFileHandles;
    @JsonProperty(value="modules")
    private List<ProcessModuleInfoInner> modules;
    @JsonProperty(value="file_name")
    private String fileName;
    @JsonProperty(value="command_line")
    private String commandLine;
    @JsonProperty(value="user_name")
    private String username;
    @JsonProperty(value="handle_count")
    private Integer handleCount;
    @JsonProperty(value="module_count")
    private Integer moduleCount;
    @JsonProperty(value="thread_count")
    private Integer threadCount;
    @JsonProperty(value="start_time")
    private OffsetDateTime startTime;
    @JsonProperty(value="total_cpu_time")
    private String totalCpuTime;
    @JsonProperty(value="user_cpu_time")
    private String userCpuTime;
    @JsonProperty(value="privileged_cpu_time")
    private String privilegedCpuTime;
    @JsonProperty(value="working_set")
    private Long workingSet;
    @JsonProperty(value="peak_working_set")
    private Long peakWorkingSet;
    @JsonProperty(value="private_memory")
    private Long privateMemory;
    @JsonProperty(value="virtual_memory")
    private Long virtualMemory;
    @JsonProperty(value="peak_virtual_memory")
    private Long peakVirtualMemory;
    @JsonProperty(value="paged_system_memory")
    private Long pagedSystemMemory;
    @JsonProperty(value="non_paged_system_memory")
    private Long nonPagedSystemMemory;
    @JsonProperty(value="paged_memory")
    private Long pagedMemory;
    @JsonProperty(value="peak_paged_memory")
    private Long peakPagedMemory;
    @JsonProperty(value="time_stamp")
    private OffsetDateTime timestamp;
    @JsonProperty(value="environment_variables")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> environmentVariables;
    @JsonProperty(value="is_scm_site")
    private Boolean isScmSite;
    @JsonProperty(value="is_webjob")
    private Boolean isWebjob;
    @JsonProperty(value="description")
    private String description;

    public Integer identifier() {
        return this.identifier;
    }

    public String deploymentName() {
        return this.deploymentName;
    }

    public ProcessInfoProperties withDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    public String href() {
        return this.href;
    }

    public ProcessInfoProperties withHref(String href) {
        this.href = href;
        return this;
    }

    public String minidump() {
        return this.minidump;
    }

    public ProcessInfoProperties withMinidump(String minidump) {
        this.minidump = minidump;
        return this;
    }

    public Boolean isProfileRunning() {
        return this.isProfileRunning;
    }

    public ProcessInfoProperties withIsProfileRunning(Boolean isProfileRunning) {
        this.isProfileRunning = isProfileRunning;
        return this;
    }

    public Boolean isIisProfileRunning() {
        return this.isIisProfileRunning;
    }

    public ProcessInfoProperties withIsIisProfileRunning(Boolean isIisProfileRunning) {
        this.isIisProfileRunning = isIisProfileRunning;
        return this;
    }

    public Double iisProfileTimeoutInSeconds() {
        return this.iisProfileTimeoutInSeconds;
    }

    public ProcessInfoProperties withIisProfileTimeoutInSeconds(Double iisProfileTimeoutInSeconds) {
        this.iisProfileTimeoutInSeconds = iisProfileTimeoutInSeconds;
        return this;
    }

    public String parent() {
        return this.parent;
    }

    public ProcessInfoProperties withParent(String parent) {
        this.parent = parent;
        return this;
    }

    public List<String> children() {
        return this.children;
    }

    public ProcessInfoProperties withChildren(List<String> children) {
        this.children = children;
        return this;
    }

    public List<ProcessThreadInfoInner> threads() {
        return this.threads;
    }

    public ProcessInfoProperties withThreads(List<ProcessThreadInfoInner> threads) {
        this.threads = threads;
        return this;
    }

    public List<String> openFileHandles() {
        return this.openFileHandles;
    }

    public ProcessInfoProperties withOpenFileHandles(List<String> openFileHandles) {
        this.openFileHandles = openFileHandles;
        return this;
    }

    public List<ProcessModuleInfoInner> modules() {
        return this.modules;
    }

    public ProcessInfoProperties withModules(List<ProcessModuleInfoInner> modules) {
        this.modules = modules;
        return this;
    }

    public String fileName() {
        return this.fileName;
    }

    public ProcessInfoProperties withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String commandLine() {
        return this.commandLine;
    }

    public ProcessInfoProperties withCommandLine(String commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    public String username() {
        return this.username;
    }

    public ProcessInfoProperties withUsername(String username) {
        this.username = username;
        return this;
    }

    public Integer handleCount() {
        return this.handleCount;
    }

    public ProcessInfoProperties withHandleCount(Integer handleCount) {
        this.handleCount = handleCount;
        return this;
    }

    public Integer moduleCount() {
        return this.moduleCount;
    }

    public ProcessInfoProperties withModuleCount(Integer moduleCount) {
        this.moduleCount = moduleCount;
        return this;
    }

    public Integer threadCount() {
        return this.threadCount;
    }

    public ProcessInfoProperties withThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public ProcessInfoProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public String totalCpuTime() {
        return this.totalCpuTime;
    }

    public ProcessInfoProperties withTotalCpuTime(String totalCpuTime) {
        this.totalCpuTime = totalCpuTime;
        return this;
    }

    public String userCpuTime() {
        return this.userCpuTime;
    }

    public ProcessInfoProperties withUserCpuTime(String userCpuTime) {
        this.userCpuTime = userCpuTime;
        return this;
    }

    public String privilegedCpuTime() {
        return this.privilegedCpuTime;
    }

    public ProcessInfoProperties withPrivilegedCpuTime(String privilegedCpuTime) {
        this.privilegedCpuTime = privilegedCpuTime;
        return this;
    }

    public Long workingSet() {
        return this.workingSet;
    }

    public ProcessInfoProperties withWorkingSet(Long workingSet) {
        this.workingSet = workingSet;
        return this;
    }

    public Long peakWorkingSet() {
        return this.peakWorkingSet;
    }

    public ProcessInfoProperties withPeakWorkingSet(Long peakWorkingSet) {
        this.peakWorkingSet = peakWorkingSet;
        return this;
    }

    public Long privateMemory() {
        return this.privateMemory;
    }

    public ProcessInfoProperties withPrivateMemory(Long privateMemory) {
        this.privateMemory = privateMemory;
        return this;
    }

    public Long virtualMemory() {
        return this.virtualMemory;
    }

    public ProcessInfoProperties withVirtualMemory(Long virtualMemory) {
        this.virtualMemory = virtualMemory;
        return this;
    }

    public Long peakVirtualMemory() {
        return this.peakVirtualMemory;
    }

    public ProcessInfoProperties withPeakVirtualMemory(Long peakVirtualMemory) {
        this.peakVirtualMemory = peakVirtualMemory;
        return this;
    }

    public Long pagedSystemMemory() {
        return this.pagedSystemMemory;
    }

    public ProcessInfoProperties withPagedSystemMemory(Long pagedSystemMemory) {
        this.pagedSystemMemory = pagedSystemMemory;
        return this;
    }

    public Long nonPagedSystemMemory() {
        return this.nonPagedSystemMemory;
    }

    public ProcessInfoProperties withNonPagedSystemMemory(Long nonPagedSystemMemory) {
        this.nonPagedSystemMemory = nonPagedSystemMemory;
        return this;
    }

    public Long pagedMemory() {
        return this.pagedMemory;
    }

    public ProcessInfoProperties withPagedMemory(Long pagedMemory) {
        this.pagedMemory = pagedMemory;
        return this;
    }

    public Long peakPagedMemory() {
        return this.peakPagedMemory;
    }

    public ProcessInfoProperties withPeakPagedMemory(Long peakPagedMemory) {
        this.peakPagedMemory = peakPagedMemory;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public ProcessInfoProperties withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public ProcessInfoProperties withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public Boolean isScmSite() {
        return this.isScmSite;
    }

    public ProcessInfoProperties withIsScmSite(Boolean isScmSite) {
        this.isScmSite = isScmSite;
        return this;
    }

    public Boolean isWebjob() {
        return this.isWebjob;
    }

    public ProcessInfoProperties withIsWebjob(Boolean isWebjob) {
        this.isWebjob = isWebjob;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ProcessInfoProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.threads() != null) {
            this.threads().forEach(e -> e.validate());
        }
        if (this.modules() != null) {
            this.modules().forEach(e -> e.validate());
        }
    }
}

