/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.LoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AppServiceEnvironment {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AppServiceEnvironment.class);
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private HostingEnvironmentStatus status;
    @JsonProperty(value="virtualNetwork", required=true)
    private VirtualNetworkProfile virtualNetwork;
    @JsonProperty(value="internalLoadBalancingMode")
    private LoadBalancingMode internalLoadBalancingMode;
    @JsonProperty(value="multiSize")
    private String multiSize;
    @JsonProperty(value="multiRoleCount", access=JsonProperty.Access.WRITE_ONLY)
    private Integer multiRoleCount;
    @JsonProperty(value="ipsslAddressCount")
    private Integer ipsslAddressCount;
    @JsonProperty(value="dnsSuffix")
    private String dnsSuffix;
    @JsonProperty(value="maximumNumberOfMachines", access=JsonProperty.Access.WRITE_ONLY)
    private Integer maximumNumberOfMachines;
    @JsonProperty(value="frontEndScaleFactor")
    private Integer frontEndScaleFactor;
    @JsonProperty(value="suspended", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean suspended;
    @JsonProperty(value="clusterSettings")
    private List<NameValuePair> clusterSettings;
    @JsonProperty(value="userWhitelistedIpRanges")
    private List<String> userWhitelistedIpRanges;
    @JsonProperty(value="hasLinuxWorkers", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean hasLinuxWorkers;
    @JsonProperty(value="dedicatedHostCount")
    private Integer dedicatedHostCount;
    @JsonProperty(value="zoneRedundant")
    private Boolean zoneRedundant;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public HostingEnvironmentStatus status() {
        return this.status;
    }

    public VirtualNetworkProfile virtualNetwork() {
        return this.virtualNetwork;
    }

    public AppServiceEnvironment withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        this.virtualNetwork = virtualNetwork;
        return this;
    }

    public LoadBalancingMode internalLoadBalancingMode() {
        return this.internalLoadBalancingMode;
    }

    public AppServiceEnvironment withInternalLoadBalancingMode(LoadBalancingMode internalLoadBalancingMode) {
        this.internalLoadBalancingMode = internalLoadBalancingMode;
        return this;
    }

    public String multiSize() {
        return this.multiSize;
    }

    public AppServiceEnvironment withMultiSize(String multiSize) {
        this.multiSize = multiSize;
        return this;
    }

    public Integer multiRoleCount() {
        return this.multiRoleCount;
    }

    public Integer ipsslAddressCount() {
        return this.ipsslAddressCount;
    }

    public AppServiceEnvironment withIpsslAddressCount(Integer ipsslAddressCount) {
        this.ipsslAddressCount = ipsslAddressCount;
        return this;
    }

    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    public AppServiceEnvironment withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    public Integer maximumNumberOfMachines() {
        return this.maximumNumberOfMachines;
    }

    public Integer frontEndScaleFactor() {
        return this.frontEndScaleFactor;
    }

    public AppServiceEnvironment withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        this.frontEndScaleFactor = frontEndScaleFactor;
        return this;
    }

    public Boolean suspended() {
        return this.suspended;
    }

    public List<NameValuePair> clusterSettings() {
        return this.clusterSettings;
    }

    public AppServiceEnvironment withClusterSettings(List<NameValuePair> clusterSettings) {
        this.clusterSettings = clusterSettings;
        return this;
    }

    public List<String> userWhitelistedIpRanges() {
        return this.userWhitelistedIpRanges;
    }

    public AppServiceEnvironment withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        this.userWhitelistedIpRanges = userWhitelistedIpRanges;
        return this;
    }

    public Boolean hasLinuxWorkers() {
        return this.hasLinuxWorkers;
    }

    public Integer dedicatedHostCount() {
        return this.dedicatedHostCount;
    }

    public AppServiceEnvironment withDedicatedHostCount(Integer dedicatedHostCount) {
        this.dedicatedHostCount = dedicatedHostCount;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public AppServiceEnvironment withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public void validate() {
        if (this.virtualNetwork() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property virtualNetwork in model AppServiceEnvironment"));
        }
        this.virtualNetwork().validate();
        if (this.clusterSettings() != null) {
            this.clusterSettings().forEach(e -> e.validate());
        }
    }
}

