/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.applicationinsights.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.applicationinsights.ApplicationInsightsManager;
import com.azure.resourcemanager.applicationinsights.fluent.ComponentAvailableFeaturesClient;
import com.azure.resourcemanager.applicationinsights.fluent.models.ApplicationInsightsComponentAvailableFeaturesInner;
import com.azure.resourcemanager.applicationinsights.implementation.ApplicationInsightsComponentAvailableFeaturesImpl;
import com.azure.resourcemanager.applicationinsights.models.ApplicationInsightsComponentAvailableFeatures;
import com.azure.resourcemanager.applicationinsights.models.ComponentAvailableFeatures;

public final class ComponentAvailableFeaturesImpl
implements ComponentAvailableFeatures {
    private static final ClientLogger LOGGER = new ClientLogger(ComponentAvailableFeaturesImpl.class);
    private final ComponentAvailableFeaturesClient innerClient;
    private final ApplicationInsightsManager serviceManager;

    public ComponentAvailableFeaturesImpl(ComponentAvailableFeaturesClient innerClient, ApplicationInsightsManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public ApplicationInsightsComponentAvailableFeatures get(String resourceGroupName, String resourceName) {
        ApplicationInsightsComponentAvailableFeaturesInner inner = this.serviceClient().get(resourceGroupName, resourceName);
        if (inner != null) {
            return new ApplicationInsightsComponentAvailableFeaturesImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ApplicationInsightsComponentAvailableFeatures> getWithResponse(String resourceGroupName, String resourceName, Context context) {
        Response<ApplicationInsightsComponentAvailableFeaturesInner> inner = this.serviceClient().getWithResponse(resourceGroupName, resourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ApplicationInsightsComponentAvailableFeaturesImpl((ApplicationInsightsComponentAvailableFeaturesInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    private ComponentAvailableFeaturesClient serviceClient() {
        return this.innerClient;
    }

    private ApplicationInsightsManager manager() {
        return this.serviceManager;
    }
}

