/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.sas;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.UserDelegationKey;
import com.azure.storage.blob.sas.BlobContainerSasPermission;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobSasServiceVersion;
import com.azure.storage.blob.sas.BlobServiceSasQueryParameters;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import java.time.OffsetDateTime;

public final class BlobServiceSasSignatureValues {
    private static final String SAS_BLOB_CONSTANT = "b";
    private static final String SAS_BLOB_SNAPSHOT_CONSTANT = "bs";
    private static final String SAS_CONTAINER_CONSTANT = "c";
    private final ClientLogger logger = new ClientLogger(BlobServiceSasSignatureValues.class);
    private final String version = BlobSasServiceVersion.V2019_12_12.getVersion();
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String containerName;
    private String blobName;
    private String resource;
    private String snapshotId;
    private String identifier;
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;
    private String preauthorizedAgentObjectId;
    private String correlationId;

    @Deprecated
    public BlobServiceSasSignatureValues() {
    }

    public BlobServiceSasSignatureValues(OffsetDateTime expiryTime, BlobContainerSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"expiryTime", (Object)expiryTime);
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.expiryTime = expiryTime;
        this.permissions = permissions.toString();
    }

    public BlobServiceSasSignatureValues(OffsetDateTime expiryTime, BlobSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"expiryTime", (Object)expiryTime);
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.expiryTime = expiryTime;
        this.permissions = permissions.toString();
    }

    public BlobServiceSasSignatureValues(String identifier) {
        StorageImplUtils.assertNotNull((String)"identifier", (Object)identifier);
        this.identifier = identifier;
    }

    @Deprecated
    public BlobServiceSasSignatureValues(String version, SasProtocol sasProtocol, OffsetDateTime startTime, OffsetDateTime expiryTime, String permission, SasIpRange sasIpRange, String identifier, String cacheControl, String contentDisposition, String contentEncoding, String contentLanguage, String contentType) {
        this.protocol = sasProtocol;
        this.startTime = startTime;
        this.expiryTime = expiryTime;
        this.permissions = permission;
        this.sasIpRange = sasIpRange;
        this.identifier = identifier;
        this.cacheControl = cacheControl;
        this.contentDisposition = contentDisposition;
        this.contentEncoding = contentEncoding;
        this.contentLanguage = contentLanguage;
        this.contentType = contentType;
    }

    public String getVersion() {
        return this.version;
    }

    @Deprecated
    public BlobServiceSasSignatureValues setVersion(String version) {
        return this;
    }

    public SasProtocol getProtocol() {
        return this.protocol;
    }

    public BlobServiceSasSignatureValues setProtocol(SasProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public BlobServiceSasSignatureValues setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public BlobServiceSasSignatureValues setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public BlobServiceSasSignatureValues setPermissions(BlobSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.permissions = permissions.toString();
        return this;
    }

    public BlobServiceSasSignatureValues setPermissions(BlobContainerSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.permissions = permissions.toString();
        return this;
    }

    public SasIpRange getSasIpRange() {
        return this.sasIpRange;
    }

    public BlobServiceSasSignatureValues setSasIpRange(SasIpRange sasIpRange) {
        this.sasIpRange = sasIpRange;
        return this;
    }

    @Deprecated
    public String getContainerName() {
        return this.containerName;
    }

    @Deprecated
    public BlobServiceSasSignatureValues setContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @Deprecated
    public String getBlobName() {
        return this.blobName;
    }

    @Deprecated
    public BlobServiceSasSignatureValues setBlobName(String blobName) {
        this.blobName = blobName == null ? null : Utility.urlDecode((String)blobName);
        return this;
    }

    @Deprecated
    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Deprecated
    public BlobServiceSasSignatureValues setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
        if (snapshotId != null && SAS_BLOB_CONSTANT.equals(this.resource)) {
            this.resource = SAS_BLOB_SNAPSHOT_CONSTANT;
        }
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public BlobServiceSasSignatureValues setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobServiceSasSignatureValues setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobServiceSasSignatureValues setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobServiceSasSignatureValues setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobServiceSasSignatureValues setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobServiceSasSignatureValues setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getPreauthorizedAgentObjectId() {
        return this.preauthorizedAgentObjectId;
    }

    public BlobServiceSasSignatureValues setPreauthorizedAgentObjectId(String preauthorizedAgentObjectId) {
        this.preauthorizedAgentObjectId = preauthorizedAgentObjectId;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public BlobServiceSasSignatureValues setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Deprecated
    public BlobServiceSasQueryParameters generateSasQueryParameters(StorageSharedKeyCredential storageSharedKeyCredentials) {
        StorageImplUtils.assertNotNull((String)"storageSharedKeyCredentials", (Object)storageSharedKeyCredentials);
        this.ensureState();
        String canonicalName = this.getCanonicalName(storageSharedKeyCredentials.getAccountName());
        String signature = storageSharedKeyCredentials.computeHmac256(this.stringToSign(canonicalName));
        return new BlobServiceSasQueryParameters(this.version, this.protocol, this.startTime, this.expiryTime, this.sasIpRange, this.identifier, this.resource, this.permissions, signature, this.cacheControl, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentType, null);
    }

    @Deprecated
    public BlobServiceSasQueryParameters generateSasQueryParameters(UserDelegationKey delegationKey, String accountName) {
        StorageImplUtils.assertNotNull((String)"delegationKey", (Object)delegationKey);
        StorageImplUtils.assertNotNull((String)"accountName", (Object)accountName);
        this.ensureState();
        String canonicalName = this.getCanonicalName(accountName);
        String signature = StorageImplUtils.computeHMac256((String)delegationKey.getValue(), (String)this.stringToSign(delegationKey, canonicalName));
        return new BlobServiceSasQueryParameters(this.version, this.protocol, this.startTime, this.expiryTime, this.sasIpRange, null, this.resource, this.permissions, signature, this.cacheControl, this.contentDisposition, this.contentEncoding, this.contentLanguage, this.contentType, delegationKey);
    }

    private void ensureState() {
        this.resource = CoreUtils.isNullOrEmpty((CharSequence)this.blobName) ? SAS_CONTAINER_CONSTANT : (this.snapshotId != null ? SAS_BLOB_SNAPSHOT_CONSTANT : SAS_BLOB_CONSTANT);
        if (this.permissions != null) {
            switch (this.resource) {
                case "b": 
                case "bs": {
                    this.permissions = BlobSasPermission.parse(this.permissions).toString();
                    break;
                }
                case "c": {
                    this.permissions = BlobContainerSasPermission.parse(this.permissions).toString();
                    break;
                }
                default: {
                    this.logger.info("Not re-parsing permissions. Resource type '{}' is unknown.", new Object[]{this.resource});
                }
            }
        }
    }

    private String getCanonicalName(String account) {
        return CoreUtils.isNullOrEmpty((CharSequence)this.blobName) ? String.format("/blob/%s/%s", account, this.containerName) : String.format("/blob/%s/%s/%s", account, this.containerName, this.blobName.replace("\\", "/"));
    }

    private String stringToSign(String canonicalName) {
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, this.resource, this.snapshotId == null ? "" : this.snapshotId, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }

    private String stringToSign(UserDelegationKey key, String canonicalName) {
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, key.getSignedObjectId() == null ? "" : key.getSignedObjectId(), key.getSignedTenantId() == null ? "" : key.getSignedTenantId(), key.getSignedStart() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedStart()), key.getSignedExpiry() == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(key.getSignedExpiry()), key.getSignedService() == null ? "" : key.getSignedService(), key.getSignedVersion() == null ? "" : key.getSignedVersion(), this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, this.resource, this.snapshotId == null ? "" : this.snapshotId, this.cacheControl == null ? "" : this.cacheControl, this.contentDisposition == null ? "" : this.contentDisposition, this.contentEncoding == null ? "" : this.contentEncoding, this.contentLanguage == null ? "" : this.contentLanguage, this.contentType == null ? "" : this.contentType);
    }
}

