/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.extensions.implementation.credential.provider;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.identity.UsernamePasswordCredentialBuilder;
import com.azure.identity.extensions.implementation.credential.TokenCredentialProviderOptions;
import com.azure.identity.extensions.implementation.credential.provider.TokenCredentialProvider;
import reactor.util.annotation.Nullable;

public class DefaultTokenCredentialProvider
implements TokenCredentialProvider {
    private final TokenCredentialProviderOptions options;

    DefaultTokenCredentialProvider() {
        this.options = new TokenCredentialProviderOptions();
    }

    DefaultTokenCredentialProvider(TokenCredentialProviderOptions options) {
        this.options = options;
    }

    @Override
    public TokenCredential get() {
        return this.get(this.options);
    }

    @Override
    public TokenCredential get(TokenCredentialProviderOptions options) {
        if (options == null) {
            return new DefaultAzureCredentialBuilder().build();
        }
        return this.resolveTokenCredential(options);
    }

    private TokenCredential resolveTokenCredential(TokenCredentialProviderOptions options) {
        String tenantId = options.getTenantId();
        String clientId = options.getClientId();
        boolean isClientIdSet = this.hasText(clientId);
        String authorityHost = options.getAuthorityHost();
        if (this.hasText(tenantId)) {
            String clientSecret = options.getClientSecret();
            if (isClientIdSet && this.hasText(clientSecret)) {
                return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).authorityHost(authorityHost)).clientSecret(clientSecret).tenantId(tenantId)).build();
            }
            String clientCertificatePath = options.getClientCertificatePath();
            if (isClientIdSet && this.hasText(clientCertificatePath)) {
                ClientCertificateCredentialBuilder builder = (ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().authorityHost(authorityHost)).tenantId(tenantId)).clientId(clientId);
                if (this.hasText(options.getClientCertificatePassword())) {
                    builder.pfxCertificate(clientCertificatePath, options.getClientCertificatePassword());
                } else {
                    builder.pemCertificate(clientCertificatePath);
                }
                return builder.build();
            }
        }
        if (isClientIdSet && this.hasText(options.getUsername()) && this.hasText(options.getPassword())) {
            return ((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)new UsernamePasswordCredentialBuilder().username(options.getUsername()).authorityHost(authorityHost)).password(options.getPassword()).clientId(clientId)).tenantId(tenantId)).build();
        }
        if (options.isManagedIdentityEnabled()) {
            ManagedIdentityCredentialBuilder builder = new ManagedIdentityCredentialBuilder();
            if (isClientIdSet) {
                builder.clientId(clientId);
            }
            return builder.build();
        }
        return new DefaultAzureCredentialBuilder().authorityHost(authorityHost).tenantId(tenantId).managedIdentityClientId(clientId).build();
    }

    private boolean hasText(@Nullable String str) {
        return str != null && !str.isEmpty() && this.containsText(str);
    }

    private boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

