/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.util.Base64Util;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum EntityDataModelType {
    BINARY("Edm.Binary", Base64Util::decodeString, byte[].class, Byte[].class),
    BOOLEAN("Edm.Boolean", Boolean::parseBoolean, new Class[0]),
    DATE_TIME("Edm.DateTime", s -> DateTimeFormatter.ISO_DATE_TIME.parseBest((CharSequence)s, OffsetDateTime::from, LocalDateTime::from), OffsetDateTime.class, ZonedDateTime.class, Instant.class, LocalDateTime.class, LocalDate.class, Date.class),
    DOUBLE("Edm.Double", Double::parseDouble, new Class[0]),
    GUID("Edm.Guid", UUID::fromString, UUID.class),
    INT32("Edm.Int32", Integer::parseInt, new Class[0]),
    INT64("Edm.Int64", Long::parseLong, Long.TYPE, Long.class),
    STRING("Edm.String", String::toString, new Class[0]);

    private final String edmType;
    private final Function<String, Object> deserializer;
    private final Set<Class<?>> typesToAnnotate;

    private EntityDataModelType(String edmType, Function<String, Object> deserializer, Class<?> ... typesToAnnotate) {
        this.edmType = edmType;
        this.deserializer = deserializer;
        this.typesToAnnotate = typesToAnnotate.length == 0 ? Collections.emptySet() : (typesToAnnotate.length == 1 ? Collections.singleton(typesToAnnotate[0]) : (Set)Arrays.stream(typesToAnnotate).collect(Collectors.toCollection(HashSet::new)));
    }

    public static EntityDataModelType fromString(String edmType) {
        for (EntityDataModelType value : EntityDataModelType.values()) {
            if (!value.edmType.equals(edmType)) continue;
            return value;
        }
        return null;
    }

    public static EntityDataModelType forClass(Class<?> clazz) {
        for (EntityDataModelType value : EntityDataModelType.values()) {
            if (!value.typesToAnnotate.contains(clazz)) continue;
            return value;
        }
        return null;
    }

    public String getEdmType() {
        return this.edmType;
    }

    public Object deserialize(String value) {
        return this.deserializer.apply(value);
    }
}

