/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat.implementation;

import com.azure.communication.chat.implementation.AzureCommunicationChatServiceImpl;
import com.azure.communication.chat.implementation.models.ChatThreadsItemCollection;
import com.azure.communication.chat.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.chat.implementation.models.CreateChatThreadOptions;
import com.azure.communication.chat.implementation.models.CreateChatThreadResult;
import com.azure.communication.chat.models.ChatThreadItem;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class ChatsImpl {
    private final ChatsService service;
    private final AzureCommunicationChatServiceImpl client;

    ChatsImpl(AzureCommunicationChatServiceImpl client) {
        this.service = (ChatsService)RestProxy.create(ChatsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateChatThreadResult>> createChatThreadWithResponseAsync(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createChatThread(this.client.getEndpoint(), repeatabilityRequestId, this.client.getApiVersion(), createChatThreadRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateChatThreadResult>> createChatThreadWithResponseAsync(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId, Context context) {
        String accept = "application/json";
        return this.service.createChatThread(this.client.getEndpoint(), repeatabilityRequestId, this.client.getApiVersion(), createChatThreadRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateChatThreadResult> createChatThreadAsync(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId) {
        return this.createChatThreadWithResponseAsync(createChatThreadRequest, repeatabilityRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CreateChatThreadResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateChatThreadResult> createChatThreadAsync(CreateChatThreadOptions createChatThreadRequest) {
        String repeatabilityRequestId = null;
        return this.createChatThreadWithResponseAsync(createChatThreadRequest, repeatabilityRequestId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CreateChatThreadResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateChatThreadResult> createChatThreadAsync(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId, Context context) {
        return this.createChatThreadWithResponseAsync(createChatThreadRequest, repeatabilityRequestId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CreateChatThreadResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateChatThreadResult createChatThread(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId) {
        return (CreateChatThreadResult)this.createChatThreadAsync(createChatThreadRequest, repeatabilityRequestId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateChatThreadResult createChatThread(CreateChatThreadOptions createChatThreadRequest) {
        String repeatabilityRequestId = null;
        return (CreateChatThreadResult)this.createChatThreadAsync(createChatThreadRequest, repeatabilityRequestId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CreateChatThreadResult> createChatThreadWithResponse(CreateChatThreadOptions createChatThreadRequest, String repeatabilityRequestId, Context context) {
        return (Response)this.createChatThreadWithResponseAsync(createChatThreadRequest, repeatabilityRequestId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatThreadItem>> listChatThreadsSinglePageAsync(Integer maxPageSize, OffsetDateTime startTime) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listChatThreads(this.client.getEndpoint(), maxPageSize, startTime, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatThreadsItemCollection)res.getValue()).getValue(), ((ChatThreadsItemCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatThreadItem>> listChatThreadsSinglePageAsync(Integer maxPageSize, OffsetDateTime startTime, Context context) {
        String accept = "application/json";
        return this.service.listChatThreads(this.client.getEndpoint(), maxPageSize, startTime, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatThreadsItemCollection)res.getValue()).getValue(), ((ChatThreadsItemCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatThreadItem> listChatThreadsAsync(Integer maxPageSize, OffsetDateTime startTime) {
        return new PagedFlux(() -> this.listChatThreadsSinglePageAsync(maxPageSize, startTime), nextLink -> this.listChatThreadsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatThreadItem> listChatThreadsAsync() {
        Integer maxPageSize = null;
        OffsetDateTime startTime = null;
        return new PagedFlux(() -> this.listChatThreadsSinglePageAsync(maxPageSize, startTime), nextLink -> this.listChatThreadsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ChatThreadItem> listChatThreadsAsync(Integer maxPageSize, OffsetDateTime startTime, Context context) {
        return new PagedFlux(() -> this.listChatThreadsSinglePageAsync(maxPageSize, startTime, context), nextLink -> this.listChatThreadsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatThreadItem> listChatThreads(Integer maxPageSize, OffsetDateTime startTime) {
        return new PagedIterable(this.listChatThreadsAsync(maxPageSize, startTime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatThreadItem> listChatThreads() {
        Integer maxPageSize = null;
        OffsetDateTime startTime = null;
        return new PagedIterable(this.listChatThreadsAsync(maxPageSize, startTime));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatThreadItem> listChatThreads(Integer maxPageSize, OffsetDateTime startTime, Context context) {
        return new PagedIterable(this.listChatThreadsAsync(maxPageSize, startTime, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteChatThreadWithResponseAsync(String chatThreadId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteChatThread(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteChatThreadWithResponseAsync(String chatThreadId, Context context) {
        String accept = "application/json";
        return this.service.deleteChatThread(this.client.getEndpoint(), chatThreadId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteChatThreadAsync(String chatThreadId) {
        return this.deleteChatThreadWithResponseAsync(chatThreadId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteChatThreadAsync(String chatThreadId, Context context) {
        return this.deleteChatThreadWithResponseAsync(chatThreadId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteChatThread(String chatThreadId) {
        this.deleteChatThreadAsync(chatThreadId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteChatThreadWithResponse(String chatThreadId, Context context) {
        return (Response)this.deleteChatThreadWithResponseAsync(chatThreadId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatThreadItem>> listChatThreadsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listChatThreadsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatThreadsItemCollection)res.getValue()).getValue(), ((ChatThreadsItemCollection)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<ChatThreadItem>> listChatThreadsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listChatThreadsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ChatThreadsItemCollection)res.getValue()).getValue(), ((ChatThreadsItemCollection)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCh")
    public static interface ChatsService {
        @Post(value="/chat/threads")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CreateChatThreadResult>> createChatThread(@HostParam(value="endpoint") String var1, @HeaderParam(value="repeatability-request-id") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") CreateChatThreadOptions var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/chat/threads")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<ChatThreadsItemCollection>> listChatThreads(@HostParam(value="endpoint") String var1, @QueryParam(value="maxPageSize") Integer var2, @QueryParam(value="startTime") OffsetDateTime var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/chat/threads/{chatThreadId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> deleteChatThread(@HostParam(value="endpoint") String var1, @PathParam(value="chatThreadId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<ChatThreadsItemCollection>> listChatThreadsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

