/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.core.util.BinaryData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="role")
@JsonTypeName(value="user")
public final class ChatRequestUserMessage
extends ChatRequestMessage {
    @JsonProperty(value="content")
    private BinaryData content;
    @JsonProperty(value="name")
    private String name;

    @JsonCreator
    private ChatRequestUserMessage(@JsonProperty(value="content") BinaryData content) {
        this.content = content;
    }

    @JsonCreator
    public ChatRequestUserMessage(String content) {
        this(BinaryData.fromString((String)content));
    }

    @JsonCreator
    public ChatRequestUserMessage(ChatMessageContentItem[] content) {
        this(BinaryData.fromObject(Arrays.stream(content).map(BinaryData::fromObject).collect(Collectors.toList())));
    }

    @JsonCreator
    public ChatRequestUserMessage(List<ChatMessageContentItem> content) {
        this(BinaryData.fromObject(content.stream().map(BinaryData::fromObject).collect(Collectors.toList())));
    }

    private BinaryData getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public ChatRequestUserMessage setName(String name) {
        this.name = name;
        return this;
    }
}

