/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.chaintest.domain;

import com.aventstack.chaintest.domain.Result;
import com.aventstack.chaintest.domain.Test;
import com.aventstack.chaintest.util.TimeUtil;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Stat {
    protected Set<String> clientId = ConcurrentHashMap.newKeySet();
    private int depth;
    private int total;
    private int passed;
    private int failed;
    private int skipped;
    private long durationMs;

    public Stat(int depth) {
        this.depth = depth;
    }

    protected void update(Test test) {
        if (this.clientId.contains(test.getClientId().toString())) {
            return;
        }
        this.clientId.add(test.getClientId().toString());
        ++this.total;
        if (Result.PASSED.getResult().equalsIgnoreCase(test.getResult())) {
            ++this.passed;
        } else if (Result.SKIPPED.getResult().equalsIgnoreCase(test.getResult())) {
            ++this.skipped;
        } else {
            ++this.failed;
        }
        this.durationMs += test.getDurationMs();
    }

    public String getDurationPretty() {
        return TimeUtil.getPrettyTime(this.getDurationMs());
    }

    @Generated
    public Set<String> getClientId() {
        return this.clientId;
    }

    @Generated
    public int getDepth() {
        return this.depth;
    }

    @Generated
    public int getTotal() {
        return this.total;
    }

    @Generated
    public int getPassed() {
        return this.passed;
    }

    @Generated
    public int getFailed() {
        return this.failed;
    }

    @Generated
    public int getSkipped() {
        return this.skipped;
    }

    @Generated
    public long getDurationMs() {
        return this.durationMs;
    }

    @Generated
    public void setClientId(Set<String> clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Generated
    public void setTotal(int total) {
        this.total = total;
    }

    @Generated
    public void setPassed(int passed) {
        this.passed = passed;
    }

    @Generated
    public void setFailed(int failed) {
        this.failed = failed;
    }

    @Generated
    public void setSkipped(int skipped) {
        this.skipped = skipped;
    }

    @Generated
    public void setDurationMs(long durationMs) {
        this.durationMs = durationMs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Stat)) {
            return false;
        }
        Stat other = (Stat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getPassed() != other.getPassed()) {
            return false;
        }
        if (this.getFailed() != other.getFailed()) {
            return false;
        }
        if (this.getSkipped() != other.getSkipped()) {
            return false;
        }
        if (this.getDurationMs() != other.getDurationMs()) {
            return false;
        }
        Set<String> this$clientId = this.getClientId();
        Set<String> other$clientId = other.getClientId();
        return !(this$clientId == null ? other$clientId != null : !((Object)this$clientId).equals(other$clientId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Stat;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDepth();
        result = result * 59 + this.getTotal();
        result = result * 59 + this.getPassed();
        result = result * 59 + this.getFailed();
        result = result * 59 + this.getSkipped();
        long $durationMs = this.getDurationMs();
        result = result * 59 + (int)($durationMs >>> 32 ^ $durationMs);
        Set<String> $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : ((Object)$clientId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Stat(clientId=" + String.valueOf(this.getClientId()) + ", depth=" + this.getDepth() + ", total=" + this.getTotal() + ", passed=" + this.getPassed() + ", failed=" + this.getFailed() + ", skipped=" + this.getSkipped() + ", durationMs=" + this.getDurationMs() + ")";
    }

    @Generated
    public Stat() {
    }
}

