/*
 * Decompiled with CFR 0.152.
 */
package com.autonomousapps.internal.antlr.v4.codegen;

public class UnicodeEscapes {
    public static String escapeCodePoint(int codePoint, String language) {
        StringBuilder result = new StringBuilder();
        UnicodeEscapes.appendEscapedCodePoint(result, codePoint, language);
        return result.toString();
    }

    public static void appendEscapedCodePoint(StringBuilder sb, int codePoint, String language) {
        switch (language) {
            case "CSharp": 
            case "Python2": 
            case "Python3": 
            case "Cpp": 
            case "Go": 
            case "PHP": {
                String format = Character.isSupplementaryCodePoint(codePoint) ? "\\U%08X" : "\\u%04X";
                sb.append(String.format(format, codePoint));
                break;
            }
            case "Swift": {
                sb.append(String.format("\\u{%04X}", codePoint));
                break;
            }
            default: {
                if (Character.isSupplementaryCodePoint(codePoint)) {
                    sb.append(String.format("\\u%04X", Character.highSurrogate(codePoint)));
                    sb.append(String.format("\\u%04X", Character.lowSurrogate(codePoint)));
                    break;
                }
                sb.append(String.format("\\u%04X", codePoint));
            }
        }
    }
}

