/*
 * Decompiled with CFR 0.152.
 */
package com.atlascopco.hunspell;

import com.atlascopco.hunspell.HunspellLibrary;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.bridj.Pointer;

public class Hunspell
implements Closeable {
    private Pointer<HunspellLibrary.Hunhandle> handle;
    private Exception closedAt;

    public Hunspell(String dictionaryPath, String affixPath) {
        Pointer affpath = Pointer.pointerToCString((String)affixPath);
        Pointer dpath = Pointer.pointerToCString((String)dictionaryPath);
        this.handle = HunspellLibrary.Hunspell_create((Pointer<Byte>)affpath, (Pointer<Byte>)dpath);
        if (this.handle == null) {
            throw new RuntimeException("Unable to instantiate Hunspell handle.");
        }
    }

    public Hunspell(String dictionaryPath, String affixPath, String key) {
        Pointer affpath = Pointer.pointerToCString((String)affixPath);
        Pointer dpath = Pointer.pointerToCString((String)dictionaryPath);
        Pointer keyCString = Pointer.pointerToCString((String)key);
        this.handle = HunspellLibrary.Hunspell_create_key((Pointer<Byte>)affpath, (Pointer<Byte>)dpath, (Pointer<Byte>)keyCString);
        if (this.handle == null) {
            throw new RuntimeException("Unable to instantiate Hunspell handle.");
        }
    }

    public boolean spell(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer wordCString = Pointer.pointerToCString((String)word);
        int result = HunspellLibrary.Hunspell_spell(this.handle, (Pointer<Byte>)wordCString);
        return result != 0;
    }

    public boolean isCorrect(String word) {
        return this.spell(word);
    }

    public String getDictionaryEncoding() {
        this.checkHandle();
        Pointer<Byte> dictionaryEncoding = HunspellLibrary.Hunspell_get_dic_encoding(this.handle);
        return dictionaryEncoding.getCString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> suggest(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer wordCString = Pointer.pointerToCString((String)word);
        Pointer slst = Pointer.allocatePointerPointer(Byte.class);
        int numResults = 0;
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            numResults = HunspellLibrary.Hunspell_suggest(this.handle, (Pointer<Pointer<Pointer<Byte>>>)slst, (Pointer<Byte>)wordCString);
            for (int i = 0; i < numResults; ++i) {
                suggestions.add(((Pointer)((Pointer)slst.get()).get((long)i)).getCString());
            }
        }
        finally {
            if (slst != null) {
                this.free_list((Pointer<Pointer<Pointer<Byte>>>)slst, numResults);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> analyze(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer wordCString = Pointer.pointerToCString((String)word);
        Pointer slst = Pointer.allocatePointerPointer(Byte.class);
        int numResults = 0;
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            numResults = HunspellLibrary.Hunspell_analyze(this.handle, (Pointer<Pointer<Pointer<Byte>>>)slst, (Pointer<Byte>)wordCString);
            for (int i = 0; i < numResults; ++i) {
                suggestions.add(((Pointer)((Pointer)slst.get()).get((long)i)).getCString());
            }
        }
        finally {
            if (slst != null) {
                this.free_list((Pointer<Pointer<Pointer<Byte>>>)slst, numResults);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> stem(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer wordCString = Pointer.pointerToCString((String)word);
        Pointer slst = Pointer.allocatePointerPointer(Byte.class);
        int numResults = 0;
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            numResults = HunspellLibrary.Hunspell_stem(this.handle, (Pointer<Pointer<Pointer<Byte>>>)slst, (Pointer<Byte>)wordCString);
            for (int i = 0; i < numResults; ++i) {
                suggestions.add(((Pointer)((Pointer)slst.get()).get((long)i)).getCString());
            }
        }
        finally {
            if (slst != null) {
                this.free_list((Pointer<Pointer<Pointer<Byte>>>)slst, numResults);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> stem(List<String> analysis) {
        this.checkHandle();
        Pointer slst = Pointer.allocatePointerPointer(Byte.class);
        Pointer analysisCStrings = Pointer.pointerToCStrings((String[])analysis.toArray(new String[analysis.size()]));
        int numResults = 0;
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            numResults = HunspellLibrary.Hunspell_stem2(this.handle, (Pointer<Pointer<Pointer<Byte>>>)slst, (Pointer<Pointer<Byte>>)analysisCStrings, analysis.size());
            for (int i = 0; i < numResults; ++i) {
                suggestions.add(((Pointer)((Pointer)slst.get()).get((long)i)).getCString());
            }
        }
        finally {
            if (slst != null) {
                this.free_list((Pointer<Pointer<Pointer<Byte>>>)slst, numResults);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> generate(String word, String basedOn) {
        this.checkHandle();
        this.checkWord("word", word);
        this.checkWord("basedOn", basedOn);
        Pointer slst = Pointer.allocatePointerPointer(Byte.class);
        Pointer wordCString = Pointer.pointerToCString((String)word);
        Pointer word2CString = Pointer.pointerToCString((String)basedOn);
        int numResults = 0;
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            numResults = HunspellLibrary.Hunspell_generate(this.handle, (Pointer<Pointer<Pointer<Byte>>>)slst, (Pointer<Byte>)wordCString, (Pointer<Byte>)word2CString);
            for (int i = 0; i < numResults; ++i) {
                suggestions.add(((Pointer)((Pointer)slst.get()).get((long)i)).getCString());
            }
        }
        finally {
            if (slst != null) {
                this.free_list((Pointer<Pointer<Pointer<Byte>>>)slst, numResults);
            }
        }
        return suggestions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> generate(String word, List<String> basedOnAnalysis) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer slst = Pointer.allocatePointerPointer(Byte.class);
        Pointer wordCString = Pointer.pointerToCString((String)word);
        Pointer analysisCStrings = Pointer.pointerToCStrings((String[])basedOnAnalysis.toArray(new String[basedOnAnalysis.size()]));
        int numResults = 0;
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            numResults = HunspellLibrary.Hunspell_generate2(this.handle, (Pointer<Pointer<Pointer<Byte>>>)slst, (Pointer<Byte>)wordCString, (Pointer<Pointer<Byte>>)analysisCStrings, basedOnAnalysis.size());
            for (int i = 0; i < numResults; ++i) {
                suggestions.add(((Pointer)((Pointer)slst.get()).get((long)i)).getCString());
            }
        }
        finally {
            if (slst != null) {
                this.free_list((Pointer<Pointer<Pointer<Byte>>>)slst, numResults);
            }
        }
        return suggestions;
    }

    public void add(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer wordCString = Pointer.pointerToCString((String)word);
        int result = HunspellLibrary.Hunspell_add(this.handle, (Pointer<Byte>)wordCString);
        if (result != 0) {
            throw new RuntimeException("An error occurred when calling Hunspell_add: " + result);
        }
    }

    public void addWithAffix(String word, String exampleWord) {
        this.checkHandle();
        this.checkWord("word", word);
        this.checkWord("exampleWord", exampleWord);
        Pointer wordCString = Pointer.pointerToCString((String)word);
        Pointer example = Pointer.pointerToCString((String)exampleWord);
        int result = HunspellLibrary.Hunspell_add_with_affix(this.handle, (Pointer<Byte>)wordCString, (Pointer<Byte>)example);
        if (result != 0) {
            throw new RuntimeException("An error occurred when calling Hunspell_add_with_affix: " + result);
        }
    }

    public void remove(String word) {
        this.checkHandle();
        this.checkWord("word", word);
        Pointer wordCString = Pointer.pointerToCString((String)word);
        int result = HunspellLibrary.Hunspell_remove(this.handle, (Pointer<Byte>)wordCString);
        if (result != 0) {
            throw new RuntimeException("An error occurred when calling Hunspell_remove: " + result);
        }
    }

    private void free_list(Pointer<Pointer<Pointer<Byte>>> slst, int n) {
        HunspellLibrary.Hunspell_free_list(this.handle, slst, n);
    }

    private void checkWord(String parameterName, String value) {
        if (value.length() > 256) {
            throw new IllegalArgumentException("Word '" + parameterName + "' greater than max acceptable length (" + 256 + "): " + value);
        }
    }

    private void checkHandle() {
        if (this.handle == null && this.closedAt != null) {
            throw new IllegalStateException("This instance has already been closed.", this.closedAt);
        }
        if (this.handle == null) {
            throw new IllegalStateException("Hunspell handle is null, but instance has not been closed.");
        }
    }

    @Override
    public void close() {
        if (this.closedAt != null) {
            return;
        }
        if (this.handle == null) {
            return;
        }
        HunspellLibrary.Hunspell_destroy(this.handle);
        this.handle = null;
        this.closedAt = new Exception();
    }

    protected void finalize() throws Throwable {
        if (this.closedAt != null) {
            this.close();
            System.err.println("Hunspell instance was not closed!");
        }
        super.finalize();
    }
}

