/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.arcmutate.spring.mutators;

import com.arcmutate.spring.licence.Licence;
import com.arcmutate.spring.licence.LicencePathFinder;
import com.groupcdg.arcmutate.spring.mutators.AnnotationMutationModifier;
import com.groupcdg.arcmutate.spring.scan.CompoundLocator;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Collection;
import java.util.function.Predicate;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.plugin.Feature;
import org.pitest.util.Glob;

public class AnnotationInterceptor
implements MutationInterceptorFactory {
    private final FileSystem fs;

    public AnnotationInterceptor() {
        this(FileSystems.getDefault());
    }

    public AnnotationInterceptor(FileSystem fs) {
        this.fs = fs;
    }

    public String description() {
        return "Updates annotation mutants";
    }

    public Feature provides() {
        return Feature.named((String)"SPRING").withOnByDefault(true).asInternalFeature().withDescription(this.description());
    }

    public MutationInterceptor createInterceptor(InterceptorParameters params) {
        CompoundLocator locator = new CompoundLocator(params.data().getSourcePaths());
        return new AnnotationMutationModifier(locator, AnnotationInterceptor.makeFilter(this.findLicence(params.data())));
    }

    private static Predicate<ClassName> makeFilter(Licence licence) {
        Collection globs = Glob.toGlobPredicates(licence.packages());
        return c -> globs.stream().anyMatch(g -> g.test(c.asJavaName()));
    }

    private Licence findLicence(ReportOptions data) {
        try {
            Path workingDir = this.fs.getPath("", new String[0]).toRealPath(new LinkOption[0]);
            Path reportDir = this.fs.getPath(data.getReportDir(), new String[0]).toRealPath(new LinkOption[0]);
            LicencePathFinder licenceFinder = new LicencePathFinder(workingDir);
            return Licence.findAndCheckLicence(Clock.systemUTC(), reportDir, data.getProjectBase(), licenceFinder, "SPRING");
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException while looking for licence");
        }
    }
}

