/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.security;

import com.arcadedb.database.DatabaseFactory;
import com.arcadedb.log.LogManager;
import com.arcadedb.serializer.json.JSONArray;
import com.arcadedb.serializer.json.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class SecurityUserFileRepository {
    public static final String FILE_NAME = "server-users.jsonl";
    private static final int BUFFER_SIZE = 655360;
    private final String securityConfPath;
    private long fileLastModified = -1L;

    public SecurityUserFileRepository(String securityConfPath) {
        if (!((String)securityConfPath).endsWith(File.separator)) {
            securityConfPath = (String)securityConfPath + File.separator;
        }
        this.securityConfPath = securityConfPath;
    }

    public void save(List<JSONObject> configuration) throws IOException {
        File file = new File(this.securityConfPath, FILE_NAME);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(file, DatabaseFactory.getDefaultCharset());){
            for (JSONObject line : configuration) {
                writer.write(line.toString() + "\n");
            }
        }
        this.fileLastModified = file.lastModified();
    }

    public List<JSONObject> getUsers() {
        try {
            return this.load();
        }
        catch (IOException e) {
            LogManager.instance().log((Object)this, Level.SEVERE, "Error on loading file '%s', using default configuration", (Throwable)e, (Object)FILE_NAME);
            return SecurityUserFileRepository.createDefault();
        }
    }

    public boolean isUserFileChanged() {
        File file = new File(this.securityConfPath, FILE_NAME);
        return file.lastModified() > this.fileLastModified;
    }

    protected List<JSONObject> load() throws IOException {
        File file = new File(this.securityConfPath, FILE_NAME);
        ArrayList<JSONObject> resultSet = new ArrayList<JSONObject>();
        if (file.exists()) {
            this.fileLastModified = file.lastModified();
            try (InputStreamReader is = new InputStreamReader(new FileInputStream(file));
                 BufferedReader reader = new BufferedReader(is, 655360);){
                while (reader.ready()) {
                    resultSet.add(new JSONObject(reader.readLine()));
                }
            }
        }
        if (!resultSet.isEmpty()) {
            return resultSet;
        }
        return SecurityUserFileRepository.createDefault();
    }

    public static List<JSONObject> createDefault() {
        return List.of(new JSONObject().put("name", "root").put("databases", (Object)new JSONObject().put("*", (Object)new JSONArray(new String[]{"admin"}))));
    }

    public long getFileLastModified() {
        return this.fileLastModified;
    }
}

