/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.monitor;

import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.event.ServerEventLog;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.management.HotspotRuntimeMBean;
import sun.management.ManagementFactoryHelper;

public class ServerMonitor {
    private static final int INTERVAL_TIME = 10000;
    private static final int MINS_30 = 1800000;
    private static final int HOURS_24 = 86400000;
    private final ArcadeDBServer server;
    private volatile Thread checker;
    private AtomicBoolean running = new AtomicBoolean(false);
    private long lastHotspotSafepointTime = 0L;
    private long lastHotspotSafepointCount = 0L;
    private long lastHeapWarningReported = 0L;
    private long lastDiskSpaceWarningReported = 0L;

    public ServerMonitor(ArcadeDBServer server) {
        this.server = server;
    }

    public void start() {
        this.running.set(true);
        this.checker = new Thread(() -> this.monitor());
        this.checker.start();
    }

    private void monitor() {
        while (this.running.get()) {
            try {
                this.checkDiskSpace();
                this.checkHeapRAM();
                this.checkJVMHotSpot();
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkDiskSpace() {
        long totalSpace;
        if (System.currentTimeMillis() - this.lastDiskSpaceWarningReported < 86400000L) {
            return;
        }
        long freeSpace = new File(".").getFreeSpace();
        float freeSpacePerc = (float)freeSpace * 100.0f / (float)(totalSpace = new File(".").getTotalSpace());
        if (freeSpacePerc < 20.0f) {
            this.server.getEventLog().reportEvent(ServerEventLog.EVENT_TYPE.WARNING, "JVM", null, "Available space on disk is only " + (int)freeSpacePerc + "%");
            this.lastDiskSpaceWarningReported = System.currentTimeMillis();
        }
    }

    private void checkHeapRAM() {
        if (System.currentTimeMillis() - this.lastHeapWarningReported < 1800000L) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        long heapUsed = runtime.totalMemory() - runtime.freeMemory();
        long heapMax = runtime.maxMemory();
        float heapAvailablePerc = (float)(heapMax - heapUsed) * 100.0f / (float)heapMax;
        if (heapAvailablePerc < 20.0f) {
            this.server.getEventLog().reportEvent(ServerEventLog.EVENT_TYPE.WARNING, "JVM", null, "Server overloaded: available heap RAM is only " + (int)heapAvailablePerc + "%");
            this.lastHeapWarningReported = System.currentTimeMillis();
        }
    }

    private void checkJVMHotSpot() {
        float lastAvgSafepointTime;
        float avgSafepointTime;
        float deltaPerc;
        HotspotRuntimeMBean runtime = ManagementFactoryHelper.getHotspotRuntimeMBean();
        long hotspotSafepointTime = runtime.getTotalSafepointTime();
        long hotspotSafepointCount = runtime.getSafepointCount();
        if (this.lastHotspotSafepointCount > 0L && (deltaPerc = ((avgSafepointTime = (float)hotspotSafepointTime / (float)hotspotSafepointCount) - (lastAvgSafepointTime = (float)this.lastHotspotSafepointTime / (float)this.lastHotspotSafepointCount)) * 100.0f / lastAvgSafepointTime) > 20.0f) {
            this.server.getEventLog().reportEvent(ServerEventLog.EVENT_TYPE.WARNING, "JVM", null, "Server overloaded: JVM Safepoint spiked up " + (int)deltaPerc + "% from the last sampling");
        }
        this.lastHotspotSafepointTime = hotspotSafepointTime;
        this.lastHotspotSafepointCount = hotspotSafepointCount;
    }

    public void stop() {
        this.running.set(false);
        if (this.checker != null) {
            try {
                this.checker.interrupt();
                this.checker.join(10100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

