/*
 * Decompiled with CFR 0.152.
 */
package com.arcadedb.server.ha.message;

import com.arcadedb.database.Binary;
import com.arcadedb.log.LogManager;
import com.arcadedb.server.ArcadeDBServer;
import com.arcadedb.server.ha.HAServer;
import com.arcadedb.server.ha.message.HAAbstractCommand;
import com.arcadedb.server.ha.message.HACommand;
import java.util.logging.Level;

public class UpdateClusterConfiguration
extends HAAbstractCommand {
    private String servers;
    private String replicaServersHTTPAddresses;

    public UpdateClusterConfiguration() {
    }

    public UpdateClusterConfiguration(String servers, String replicaServersHTTPAddresses) {
        this.servers = servers;
        this.replicaServersHTTPAddresses = replicaServersHTTPAddresses;
    }

    @Override
    public HACommand execute(HAServer server, String remoteServerName, long messageNumber) {
        LogManager.instance().log((Object)this, Level.FINE, "Updating server list=%s replicaHTTPs=%s", (Object)this.servers, (Object)this.replicaServersHTTPAddresses);
        server.setServerAddresses(this.servers);
        server.setReplicasHTTPAddresses(this.replicaServersHTTPAddresses);
        return null;
    }

    @Override
    public void toStream(Binary stream) {
        stream.putString(this.servers);
        stream.putString(this.replicaServersHTTPAddresses);
    }

    @Override
    public void fromStream(ArcadeDBServer server, Binary stream) {
        this.servers = stream.getString();
        this.replicaServersHTTPAddresses = stream.getString();
    }

    public String toString() {
        return "updateClusterConfig(servers=" + this.servers + ")";
    }
}

